package com.flybits.concierge.viewpopulators

import android.content.Intent
import android.net.Uri
import android.text.TextUtils
import android.view.View
import android.webkit.URLUtil
import android.widget.TextView
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.models.Link

/**
 * Handles logic for populating Links
 *
 */
class LinksViewPopulator(private val contentAnalytics: ContentAnalytics) {
    val TAG = "LinkViewPop"
    /**
     * Populates link views with data provided
     *
     * @param link Link model data to inject into the views
     * @param parentContentId Id of the link used for analytics
     *
     * All other parameters are views related to a particular link view
     */
    fun populate(link: Link, parentContentId: String, txtHeading: TextView, txtBody: TextView, linkView: View) {
        txtHeading.text = if (!TextUtils.isEmpty(link.title.value)) link.title.value else ""

        txtBody.text = if (!TextUtils.isEmpty(link.description.value)) link.description.value else ""
        txtBody.visibility = if (TextUtils.isEmpty(link.description.value)) View.GONE else View.VISIBLE

        linkView.setOnClickListener { v ->
            contentAnalytics.trackEngaged(parentContentId)
            val url = link.url
            if (URLUtil.isValidUrl(url)) {
                val intent = Intent(Intent.ACTION_VIEW)
                intent.data = Uri.parse(url)
                v.context.startActivity(intent)
            } else {
                Logger.appendTag(TAG).e("Invalid url for Link")
            }
        }
    }
}