package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.RelativeLayout
import android.widget.Switch
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback
import com.flybits.commons.library.exceptions.FlybitsException
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.R
import com.flybits.concierge.activities.DocumentActivity
import com.flybits.concierge.activities.NotificationsActivity
import com.flybits.concierge.guidedoptin.presentation.view.GuidedOptInActivity
import com.flybits.concierge.guidedoptin.presentation.view.GuidedOptInActivity.Companion.IS_OPT_IN
import com.flybits.concierge.viewmodels.SettingsViewModel
import com.flybits.concierge.viewmodels.SettingsViewModelFactory

class SettingsFragment : Fragment() {

    private var optSwitch: Switch? = null
    internal var viewModel: SettingsViewModel? = null

    override fun onResume() {
        super.onResume()
        optSwitch?.isChecked = false
        FlybitsConcierge.with(context).isOptedInLocal(object : ObjectResultCallback<Boolean> {
            /**
             * Indicates that the request failed.
             *
             * @param exception The [FlybitsException] that indicates the exception that was thrown.
             */
            override fun onException(exception: FlybitsException) {
                //No op
            }

            /**
             * Indicates that the request was successfully made.
             *
             * @param item The item that is expected to be returned.
             */
            override fun onSuccess(item: Boolean) {
                if (!item) {
                    activity?.finish()
                }
            }
        })
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_settings, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        viewModel = ViewModelProviders.of(this, SettingsViewModelFactory(context!!)).get(SettingsViewModel::class.java)

        if (arguments?.getBoolean(ARG_SHOW_OPT_OUT_CELL, true) == false) {
            view.findViewById<RelativeLayout>(R.id.flybits_con_settings_opt_in_holder).visibility = View.GONE
        } else {
            optSwitch = view.findViewById(R.id.flybits_con_settings_opt_switch)
            optSwitch?.setOnClickListener {
                if (optSwitch?.isChecked == true) {
                    context?.let { FlybitsConcierge.with(it).presentGuidedOptOut(it) }
                }
            }
        }

        val termsOfServiceCell = view.findViewById<RelativeLayout>(R.id.flybits_con_terms_of_service_cell)
        val privacyPolicyCell = view.findViewById<RelativeLayout>(R.id.flybits_con_privacy_policy_cell)
        val notificationsCell = view.findViewById<RelativeLayout>(R.id.flybits_notifications_cell)

        if (arguments?.getBoolean(ARG_SHOW_NOTIFICATIONS_CELL, false) == false){
            notificationsCell.visibility = View.GONE
        } else {
            notificationsCell.setOnClickListener {
                val startNotificationsIntent = Intent(activity, NotificationsActivity::class.java)
                startActivity(startNotificationsIntent)
            }
        }

        termsOfServiceCell?.setOnClickListener {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_TOS)
            startActivity(activityIntent)
        }

        privacyPolicyCell?.setOnClickListener {
            val activityIntent = Intent(context, DocumentActivity::class.java)
            activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_PRIVACY_POLICY)
            startActivity(activityIntent)
        }
    }

    override fun onActivityResult(requestCode: Int, resultCode: Int, data: Intent?) {
        if (requestCode == OPT_OUT_REQUEST_CODE) {
            optSwitch?.isChecked = true
            activity?.finish()
        }
    }

    override fun onStop() {
        super.onStop()
        optSwitch?.isChecked = false
    }

    companion object {
        const val ARG_SHOW_NOTIFICATIONS_CELL = "flybits_con_arg_show_notifications_cell"
        const val ARG_SHOW_OPT_OUT_CELL = "flybits_con_arg_show_opt_out_cell"
        const val ARG_OPT_OUT_CELL_TITLE = "flybits_con_arg_opt_out_cell_title"
        const val ARG_OPT_OUT_CELL_MESSAGE = "flybits_con_arg_opt_out_cell_message"
        const val OPT_OUT_REQUEST_CODE = 321

        fun newInstance(showNotificationsCell: Boolean = false, showOptOutCell: Boolean = true, optOutCellTitle: String? = null, optOutCellMessage: String? = null): SettingsFragment {
            val fragment = SettingsFragment()
            val arguments = Bundle()
            arguments.putBoolean(ARG_SHOW_NOTIFICATIONS_CELL, showNotificationsCell)
            arguments.putBoolean(ARG_SHOW_OPT_OUT_CELL, showOptOutCell)
            arguments.putString(ARG_OPT_OUT_CELL_TITLE, optOutCellTitle)
            arguments.putString(ARG_OPT_OUT_CELL_MESSAGE, optOutCellMessage)
            fragment.arguments = arguments
            return fragment
        }
    }

}
