package com.flybits.concierge.adapters

import android.R
import android.support.v7.widget.RecyclerView
import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.models.BaseTemplate
import com.flybits.concierge.models.NotificationContent
import com.flybits.concierge.viewholders.FlybitsViewHolder
import com.flybits.concierge.viewholders.UnknownViewHolder

class NotificationAdapter(private val flybitsViewProviderGetter: FlybitsViewProviderGetter
                          , private val flybitsNavigator: FlybitsNavigator): RecyclerView.Adapter<FlybitsViewHolder<BaseTemplate>>() {

    internal val currentList = mutableListOf<NotificationContent>()

    fun submitList(list: List<NotificationContent>){
        currentList.clear()
        currentList.addAll(list)
        notifyDataSetChanged()
    }

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): FlybitsViewHolder<BaseTemplate> {

        //Try to find flybits view provider with associated content type, if not found then use first provider in list
        val provider = flybitsViewProviderGetter.flybitsViewProviders
                ?.find { it.getContentType().hashCode() == viewType }

        return provider?.onCreateViewHolder(parent) ?: UnknownViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.simple_list_item_1, parent, false))
    }

    override fun onBindViewHolder(holder: FlybitsViewHolder<BaseTemplate>, position: Int) {
        currentList[position].let {
            holder.bindData(it.baseTemplate, flybitsNavigator)
        }
    }

    override fun getItemCount() = currentList.size

    override fun getItemViewType(position: Int) = currentList[position].baseTemplate.content.type?.hashCode() ?: 0

    override fun getItemId(position: Int): Long {
        return currentList[position].baseTemplate.content.id.hashCode().toLong()
    }
}
