package com.flybits.concierge.activities

import android.content.Intent
import android.os.Bundle
import android.support.v4.app.Fragment
import com.flybits.concierge.R
import com.flybits.concierge.fragments.ActionCardDetailFragment
import kotlinx.android.synthetic.main.flybits_streamline_actioncard_activity.*

class ActionCardDetailActivity : SingleFragmentActivity() {

    companion object {
        const val EXTRA_ACTIONCARD_DETAILS = "flybits_con_extra_actioncard_details"
        const val EXTRA_USER_ACTION_HANDLER = "flybits_con_extra_user_action_handler"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        return ActionCardDetailFragment.newInstance(
            intent.getParcelableExtra(EXTRA_ACTIONCARD_DETAILS),
            intent.getParcelableExtra(EXTRA_USER_ACTION_HANDLER)
        )
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        setContentView(R.layout.flybits_streamline_actioncard_activity)

        // add custom back button
        setSupportActionBar(action_detail_toolbar)
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        supportActionBar?.setDisplayShowHomeEnabled(true)
    }
}
