package com.flybits.concierge.guidedoptin.domain

/**
 * Contract for use case.
 *
 * @param Type The return type which is the result of the executed use case.
 * @param Params The parameters with extra data for the use case.
 */
internal interface UseCase<out Type, in Params> where Type: Any? {
    // The out keyword declares the class to be covariant on a certain type parameter.
    // A covariant class is a generic class for which the following holds:
    // Producer<A> is a subtype of Producer<B> if A is a subtype of B.
    // It is said that the subtyping is preserved.
    // The in keyword declares the class to be contravariant on a certain type parameter.
    suspend fun execute(vararg args: Params): Type
}