package com.flybits.concierge.guidedoptin.data.model.json

import com.flybits.concierge.guidedoptin.*
import com.flybits.concierge.guidedoptin.domain.entity.LocationOptInEntity

/**
 * The Location Services model that is a specific implementation of [LocationOptInEntity] with Android JSON parser.
 */
internal data class LocationOptInModel(
    override val exclude: Boolean = false,
    override val title: String = locationTitleDefault,
    override val info: List<LocationOptInItemModel> = listOf(
        LocationOptInItemModel(
            locationImageOneDefault,
            locationBodyOneDefault
        ),
        LocationOptInItemModel(
            locationImageTwoDefault,
            locationBodyTwoDefault
        ),
        LocationOptInItemModel(
            locationImageThreeDefault,
            locationBodyThreeDefault
        )
    ),
    override val next: String = guidedContinueDefault,
    override val skip: String = guidedSkipDefault
) : LocationOptInEntity
