package com.flybits.concierge.guidedoptin.data.model.json

import com.flybits.concierge.guidedoptin.*
import com.flybits.concierge.guidedoptin.domain.entity.BenefitsOptInEntity

/**
 * The Benefits model that is a specific implementation of [BenefitsOptInEntity] with Android JSON parser.
 */
internal data class BenefitsOptInModel(
    override val title: String = benefitsTitleDefault,
    override val content: List<BenefitsOptInItemModel> = listOf(
        BenefitsOptInItemModel(
            benefitsImageOneDefault,
            benefitsBodyOneDefault
        ),
        BenefitsOptInItemModel(
            benefitsImageTwoDefault,
            benefitsBodyTwoDefault
        ),
        BenefitsOptInItemModel(
            benefitsImageThreeDefault,
            benefitsBodyThreeDefault
        )
    ),
    override val disclaimer: String = benefitsDisclaimerDefault,
    override val disclaimerCheckBox: Boolean = true,
    override val buttonTitle: String = guidedContinueDefault
): BenefitsOptInEntity