package com.flybits.concierge.activities

import android.os.Bundle
import android.support.v7.widget.Toolbar
import android.view.View
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.DisplayConfiguration
import com.flybits.concierge.R

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views. This version has a Dialog/Popup theme to it.
 */

class ConciergePopupActivity : ConciergeAbstractActivity() {
    lateinit var fragment: ConciergeFragment
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)
        val toolbar = findViewById<Toolbar>(R.id.concierge_activity_toolbar)
        toolbar.visibility = View.GONE
        fragment = ConciergeFragment.newInstance(
            intent.getParcelableExtra<DisplayConfiguration>(ARG_DISPLAY_CONFIGURATION)
        )
        fragment.setCallback { finish() }
        openFragment(fragment)
    }

    companion object {
        const val ARG_DISPLAY_CONFIGURATION = "flybits_con_display_configuration"
    }
}
