/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.guidedoptin.presentation.mapper;

import android.content.res.Resources;
import com.flybits.concierge.guidedoptin.GuidedOptInUtilKt;
import com.flybits.concierge.guidedoptin.domain.entity.BenefitsOptInEntity;
import com.flybits.concierge.guidedoptin.domain.entity.BenefitsOptInItemEntity;
import com.flybits.concierge.guidedoptin.domain.entity.ConciergeOptOutEntity;
import com.flybits.concierge.guidedoptin.domain.entity.ConciergeOptOutItemEntity;
import com.flybits.concierge.guidedoptin.domain.entity.GuidedOptInEntity;
import com.flybits.concierge.guidedoptin.domain.entity.LocationOptInEntity;
import com.flybits.concierge.guidedoptin.domain.entity.LocationOptInItemEntity;
import com.flybits.concierge.guidedoptin.domain.entity.NotificationsOptInEntity;
import com.flybits.concierge.guidedoptin.domain.entity.NotificationsOptInItemEntity;
import com.flybits.concierge.guidedoptin.presentation.model.BenefitsOptIn;
import com.flybits.concierge.guidedoptin.presentation.model.BenefitsOptInItem;
import com.flybits.concierge.guidedoptin.presentation.model.ConciergeOptOut;
import com.flybits.concierge.guidedoptin.presentation.model.ConciergeOptOutItem;
import com.flybits.concierge.guidedoptin.presentation.model.GuidedOptIn;
import com.flybits.concierge.guidedoptin.presentation.model.LocationOptIn;
import com.flybits.concierge.guidedoptin.presentation.model.LocationOptInItem;
import com.flybits.concierge.guidedoptin.presentation.model.NotificationsOptIn;
import com.flybits.concierge.guidedoptin.presentation.model.NotificationsOptInItem;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u0003\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\fJ\u001e\u0010\u0003\u001a\u00020\r2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001e\u0010\u0003\u001a\u00020\u00102\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0011J\u001e\u0010\u0003\u001a\u00020\u00122\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0013\u00a8\u0006\u0014"}, d2={"Lcom/flybits/concierge/guidedoptin/presentation/mapper/DataToPresentationMapper;", "", "()V", "map", "Lcom/flybits/concierge/guidedoptin/presentation/model/BenefitsOptIn;", "res", "Landroid/content/res/Resources;", "packageName", "", "entity", "Lcom/flybits/concierge/guidedoptin/domain/entity/BenefitsOptInEntity;", "Lcom/flybits/concierge/guidedoptin/presentation/model/ConciergeOptOut;", "Lcom/flybits/concierge/guidedoptin/domain/entity/ConciergeOptOutEntity;", "Lcom/flybits/concierge/guidedoptin/presentation/model/GuidedOptIn;", "model", "Lcom/flybits/concierge/guidedoptin/domain/entity/GuidedOptInEntity;", "Lcom/flybits/concierge/guidedoptin/presentation/model/LocationOptIn;", "Lcom/flybits/concierge/guidedoptin/domain/entity/LocationOptInEntity;", "Lcom/flybits/concierge/guidedoptin/presentation/model/NotificationsOptIn;", "Lcom/flybits/concierge/guidedoptin/domain/entity/NotificationsOptInEntity;", "concierge_release"})
public final class DataToPresentationMapper {
    @NotNull
    public final GuidedOptIn map(@NotNull Resources res, @NotNull String packageName, @NotNull GuidedOptInEntity model) {
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        GuidedOptIn guidedOptIn = new GuidedOptIn(this.map(res, packageName, model.getBenefits()), this.map(res, packageName, model.getLocation()), this.map(res, packageName, model.getNotifications()), this.map(res, packageName, model.getConciergeOptOut()));
        GuidedOptInUtilKt.log$default(false, "DataToPresentationMapper", "Presentation Guided Opt-In model: " + guidedOptIn, null, 8, null);
        return guidedOptIn;
    }

    @NotNull
    public final BenefitsOptIn map(@NotNull Resources res, @NotNull String packageName, @NotNull BenefitsOptInEntity entity) {
        int benefitsButtonTitle;
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        int benefitsTitle = res.getIdentifier(entity.getTitle(), "string", packageName);
        if (benefitsTitle == 0) {
            benefitsTitle = res.getIdentifier("flybits_guided_benefits_title", "string", packageName);
        }
        boolean bl = false;
        List benefitsOptInItems = new ArrayList();
        for (BenefitsOptInItemEntity i : entity.getContent()) {
            int bodyRes = 0;
            if (StringsKt.isBlank((CharSequence)i.getBody())) {
                bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
            } else {
                bodyRes = res.getIdentifier(i.getBody(), "string", packageName);
                if (bodyRes == 0) {
                    bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
                }
            }
            BenefitsOptInItem item = new BenefitsOptInItem(res.getIdentifier(i.getImage(), "drawable", packageName), bodyRes);
            benefitsOptInItems.add(item);
        }
        int benefitsDisclaimer = res.getIdentifier(entity.getDisclaimer(), "string", packageName);
        if (benefitsDisclaimer == 0) {
            benefitsDisclaimer = res.getIdentifier("flybits_guided_benefits_disclaimer", "string", packageName);
        }
        if ((benefitsButtonTitle = res.getIdentifier(entity.getButtonTitle(), "string", packageName)) == 0) {
            benefitsButtonTitle = res.getIdentifier("flybits_guided_continue_text", "string", packageName);
        }
        return new BenefitsOptIn(benefitsTitle, benefitsOptInItems, benefitsDisclaimer, entity.getDisclaimerCheckBox(), benefitsButtonTitle);
    }

    @NotNull
    public final LocationOptIn map(@NotNull Resources res, @NotNull String packageName, @NotNull LocationOptInEntity entity) {
        int locationSkip;
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        int locationTitle = res.getIdentifier(entity.getTitle(), "string", packageName);
        if (locationTitle == 0) {
            locationTitle = res.getIdentifier("flybits_guided_location_title", "string", packageName);
        }
        boolean bl = false;
        List locationOptInItems = new ArrayList();
        for (LocationOptInItemEntity i : entity.getInfo()) {
            int bodyRes = 0;
            if (StringsKt.isBlank((CharSequence)i.getBody())) {
                bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
            } else {
                bodyRes = res.getIdentifier(i.getBody(), "string", packageName);
                if (bodyRes == 0) {
                    bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
                }
            }
            LocationOptInItem item = new LocationOptInItem(res.getIdentifier(i.getImage(), "drawable", packageName), bodyRes);
            locationOptInItems.add(item);
        }
        int locationNext = res.getIdentifier(entity.getNext(), "string", packageName);
        if (locationNext == 0) {
            locationNext = res.getIdentifier("flybits_guided_continue_text", "string", packageName);
        }
        if ((locationSkip = res.getIdentifier(entity.getSkip(), "string", packageName)) == 0) {
            locationSkip = res.getIdentifier("flybits_guided_skip_text", "string", packageName);
        }
        return new LocationOptIn(entity.getExclude(), locationTitle, locationOptInItems, locationNext, locationSkip);
    }

    @NotNull
    public final NotificationsOptIn map(@NotNull Resources res, @NotNull String packageName, @NotNull NotificationsOptInEntity entity) {
        int notificationsSkip;
        int notificationsNext;
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        int notificationsTitle = res.getIdentifier(entity.getTitle(), "string", packageName);
        if (notificationsTitle == 0) {
            notificationsTitle = res.getIdentifier("flybits_guided_notification_title", "string", packageName);
        }
        boolean bl = false;
        List notificationsOptInItems = new ArrayList();
        for (NotificationsOptInItemEntity i : entity.getInfo()) {
            int bodyRes = 0;
            if (StringsKt.isBlank((CharSequence)i.getBody())) {
                bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
            } else {
                bodyRes = res.getIdentifier(i.getBody(), "string", packageName);
                if (bodyRes == 0) {
                    bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
                }
            }
            NotificationsOptInItem item = new NotificationsOptInItem(res.getIdentifier(i.getImage(), "drawable", packageName), bodyRes);
            notificationsOptInItems.add(item);
        }
        int notificationsDisclaimerText = res.getIdentifier(entity.getDisclaimerText(), "string", packageName);
        if (notificationsDisclaimerText == 0) {
            notificationsDisclaimerText = res.getIdentifier("flybits_guided_notification_disclaimer_text", "string", packageName);
        }
        if ((notificationsNext = res.getIdentifier(entity.getNext(), "string", packageName)) == 0) {
            notificationsNext = res.getIdentifier("flybits_guided_continue_text", "string", packageName);
        }
        if ((notificationsSkip = res.getIdentifier(entity.getSkip(), "string", packageName)) == 0) {
            notificationsSkip = res.getIdentifier("flybits_guided_skip_text", "string", packageName);
        }
        return new NotificationsOptIn(entity.getExclude(), notificationsTitle, notificationsOptInItems, notificationsDisclaimerText, notificationsNext, notificationsSkip);
    }

    @NotNull
    public final ConciergeOptOut map(@NotNull Resources res, @NotNull String packageName, @NotNull ConciergeOptOutEntity entity) {
        int conciergeOptOutCancel;
        Intrinsics.checkParameterIsNotNull((Object)res, (String)"res");
        Intrinsics.checkParameterIsNotNull((Object)packageName, (String)"packageName");
        Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
        int conciergeOptOutTitle = res.getIdentifier(entity.getTitle(), "string", packageName);
        if (conciergeOptOutTitle == 0) {
            conciergeOptOutTitle = res.getIdentifier("flybits_guided_opt_out_title", "string", packageName);
        }
        boolean bl = false;
        List conciergeOptOutItems = new ArrayList();
        for (ConciergeOptOutItemEntity i : entity.getInfo()) {
            int bodyRes = 0;
            if (StringsKt.isBlank((CharSequence)i.getBody())) {
                bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
            } else {
                bodyRes = res.getIdentifier(i.getBody(), "string", packageName);
                if (bodyRes == 0) {
                    bodyRes = res.getIdentifier("flybits_guided_empty_string", "string", packageName);
                }
            }
            ConciergeOptOutItem item = new ConciergeOptOutItem(res.getIdentifier(i.getImage(), "drawable", packageName), bodyRes);
            conciergeOptOutItems.add(item);
        }
        int conciergeOptOutConfirm = res.getIdentifier(entity.getConfirm(), "string", packageName);
        if (conciergeOptOutConfirm == 0) {
            conciergeOptOutConfirm = res.getIdentifier("flybits_con_opt_out", "string", packageName);
        }
        if ((conciergeOptOutCancel = res.getIdentifier(entity.getCancel(), "string", packageName)) == 0) {
            conciergeOptOutCancel = res.getIdentifier("flybits_con_cancel", "string", packageName);
        }
        return new ConciergeOptOut(conciergeOptOutTitle, conciergeOptOutItems, conciergeOptOutConfirm, conciergeOptOutCancel);
    }
}

