package com.flybits.concierge.utils

import android.content.Context
import android.content.pm.PackageManager
import android.support.v4.app.NotificationManagerCompat
import android.support.v4.content.ContextCompat

/**
 * Checks for the specific permission.
 * @param context Context of the View.
 * @param requiredPermission permission name defined.
 * @return boolean true if permission is granted else false.
 */
fun isPermissionGranted(context: Context, requiredPermission: String): Boolean =
    ContextCompat.checkSelfPermission(
        context,
        requiredPermission
    ) == PackageManager.PERMISSION_GRANTED


/**
 * Checks if notification for the application are enabled.
 * @param context Context of the View.
 * @return boolean true if enabled else false.
 */
fun areNotificationEnabled(context: Context) =
    NotificationManagerCompat.from(context).areNotificationsEnabled()