package com.flybits.concierge.guidedoptin.presentation.model

import com.flybits.concierge.R

/**
 * The model of Concierge Opt Out data that is ready to be used in presentation layer by Views through ViewModels.
 */
internal data class ConciergeOptOut(
    val title: Int = R.string.flybits_guided_opt_out_title,
    val info: List<ConciergeOptOutItem> = listOf(
        ConciergeOptOutItem(
            R.drawable.flybits_guided_opt_out_img_one,
            R.string.flybits_guided_opt_out_body_one
        ),
        ConciergeOptOutItem(
            R.drawable.flybits_guided_opt_out_img_two,
            R.string.flybits_guided_opt_out_body_two
        ),
        ConciergeOptOutItem(
            R.drawable.flybits_guided_opt_out_img_three,
            R.string.flybits_guided_opt_out_body_three
        )
    ),
    val confirmTitle: Int = R.string.flybits_con_opt_out,
    val cancelTitle: Int = R.string.flybits_con_cancel
)