package com.flybits.concierge.guidedoptin.presentation.adapter

import android.app.Activity
import android.content.Context
import android.support.v4.view.PagerAdapter
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.model.BenefitsOptInItem

/**
 *
 * This ViewPagerAdapter is the adapter for setting the Benefits Opt In Items.
 *
 * @param activity the type of a member in this group.
 * @property benefitsOptIn holds the list of BenefitsOptInItem.
 */
internal class ViewPagerAdapter(
    var activity: Activity?,
    var benefitsOptIn: List<BenefitsOptInItem>
) :
    PagerAdapter() {
    private var layoutInflater: LayoutInflater? = null

    override fun instantiateItem(container: ViewGroup, position: Int): Any {
        layoutInflater =
            activity!!.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater
        val view: View = layoutInflater!!.inflate(
            R.layout.flybits_guided_benefits_pager_item,
            container,
            false
        )
        val benefitsOptInViewpagerImage: ImageView =
            view.findViewById(R.id.flybits_guided_benefits_item_image) as ImageView
        Glide.with(view.context).load(benefitsOptIn[position].image)
            .into(benefitsOptInViewpagerImage)

        val benefitsOptInViewpagerTitle: TextView =
            view.findViewById(R.id.flybits_guided_benefits_item_description) as TextView
        benefitsOptInViewpagerTitle.text =
            activity?.resources?.getString(benefitsOptIn[position].body)


        container.addView(view)
        return view
    }

    override fun getCount(): Int {
        return benefitsOptIn.size
    }

    override fun isViewFromObject(view: View, obj: Any): Boolean {
        return view === obj
    }

    override fun destroyItem(container: ViewGroup, position: Int, `object`: Any) {
        val view = `object` as View
        container.removeView(view)
    }
}