package com.flybits.concierge.guidedoptin.data.model.json

import com.flybits.concierge.guidedoptin.*
import com.flybits.concierge.guidedoptin.domain.entity.ConciergeOptOutEntity

/**
 * The Concierge Opt Out model that is a specific implementation of [ConciergeOptOutEntity] with Android JSON parser.
 */
internal data class ConciergeOptOutModel(
    override val title: String = conciergeOptOutTitleDefault,
    override val info: List<ConciergeOptOutItemModel> = listOf(
        ConciergeOptOutItemModel(
            conciergeOptOutImageOneDefault,
            conciergeOptOutBodyOneDefault
        ),
        ConciergeOptOutItemModel(
            conciergeOptOutImageTwoDefault,
            conciergeOptOutBodyTwoDefault
        ),
        ConciergeOptOutItemModel(
            conciergeOptOutImageThreeDefault,
            conciergeOptOutBodyThreeDefault
        )
    ),
    override val confirm: String = guidedConfirmDefault,
    override val cancel: String = guidedCancelDefault
) : ConciergeOptOutEntity