package com.flybits.concierge.viewproviders

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.ConciergeConstants.SCHEDULE_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.fragments.ScheduleFeedFragment
import com.flybits.concierge.models.Schedule
import com.flybits.concierge.viewholders.FlybitsViewHolder
import com.flybits.concierge.viewholders.ScheduleViewHolder
import com.flybits.concierge.viewpopulators.ScheduleViewPopulator

@Deprecated("Schedule Content Template ViewProvider will be disabled in v4.0.0")
class ScheduleViewProvider internal constructor(private val scheduleViewPopulator: ScheduleViewPopulator): FlybitsViewProvider<Schedule> {

    constructor(context : Context) : this(ScheduleViewPopulator(ContentAnalytics(context)))

    override fun getClassType() = Schedule::class.java

    override fun getContentType() = SCHEDULE_CONTENT_TYPE

    override fun onCreateViewHolder(parent: ViewGroup): FlybitsViewHolder<Schedule> {
        return ScheduleViewHolder(LayoutInflater.from(parent.context).inflate(R.layout.flybits_con_item_template_schedule, parent, false), scheduleViewPopulator)
    }

    override fun onPushOpened(model: Schedule, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openFragment(ScheduleFeedFragment.newInstance(model))
    }
}