package com.flybits.concierge.viewproviders

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.ConciergeConstants.IMAGE_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.fragments.ImageViewerPagerFragment
import com.flybits.concierge.models.Images
import com.flybits.concierge.viewholders.ImageViewHolder
import com.flybits.concierge.viewpopulators.ImagesViewPopulator

@Deprecated("Image Content Template ViewProvider will be disabled in v4.0.0")
class ImageViewProvider internal constructor(private val imagesViewPopulator: ImagesViewPopulator): FlybitsViewProvider<Images> {

    constructor(context : Context) : this(ImagesViewPopulator(ContentAnalytics(context)))

    override fun onCreateViewHolder(parent: ViewGroup): ImageViewHolder {
        return ImageViewHolder(LayoutInflater.from(parent.context)
                        .inflate(R.layout.flybits_con_item_image, parent, false), imagesViewPopulator)
    }

    override fun getClassType() = Images::class.java

    override fun getContentType() = IMAGE_CONTENT_TYPE

    override fun onPushOpened(model: Images, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openFragment(ImageViewerPagerFragment.newInstance(model.images, 0))
    }
}