package com.flybits.concierge.viewproviders

import android.content.Context
import android.view.LayoutInflater
import android.view.ViewGroup
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.ConciergeConstants.ARTICLE_CONTENT_TYPE
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProvider
import com.flybits.concierge.R
import com.flybits.concierge.models.Articles
import com.flybits.concierge.viewholders.ArticlesViewHolder
import com.flybits.concierge.viewpopulators.ArticlesViewPopulator

@Deprecated("Articles Content Template ViewProvider will be disabled in v4.0.0")
class ArticlesViewProvider internal constructor(private val articlesViewPopulator: ArticlesViewPopulator): FlybitsViewProvider<Articles> {

    constructor(context : Context) : this(ArticlesViewPopulator(ContentAnalytics(context)))

    override fun getClassType() = Articles::class.java

    override fun getContentType() = ARTICLE_CONTENT_TYPE

    override fun onCreateViewHolder(container: ViewGroup): ArticlesViewHolder {
        val itemView = LayoutInflater.from(container.context).inflate(R.layout.flybits_con_item_articles, container, false)

        return ArticlesViewHolder(itemView, articlesViewPopulator)
    }

    override fun onPushOpened(model: Articles, flybitsNavigator: FlybitsNavigator) {
        flybitsNavigator.openUrl(model.articles.list[0].url)
    }
}