package com.flybits.concierge.viewpopulators

import android.support.v4.content.ContextCompat
import android.view.View
import android.widget.ImageView
import android.widget.TextView
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.R
import com.flybits.concierge.Utils
import com.flybits.concierge.fragments.ScheduleSegmentFragment
import com.flybits.concierge.models.ScheduleSegment
import java.util.*

/**
 *  Handles logic to populate scheduleSegment data into Schedule related views
 */
class ScheduleViewPopulator(private val contentAnalytics: ContentAnalytics) {

    /**
     *  Populates data into schedule views and also adds a listener to one of the views
     *  @param flybitsNavigator handles content click behaviour
     *  @param data ScheduleSegment data to view
     *
     *  All other parameters are views related to Schedule which will be populated
     */
    fun populate(flybitsNavigator: FlybitsNavigator, data: ScheduleSegment, clickableArea: View, timeRangeView: TextView
                 , titleView: TextView, descriptionView: TextView
                 , bulletOutView: ImageView, bulletInView: ImageView
    ){

        clickableArea.setOnClickListener {
            contentAnalytics.trackEngaged(data.content.id)
            val fragment = ScheduleSegmentFragment.newInstance(data)
            flybitsNavigator.openFragment(fragment)
        }

        populate(data, timeRangeView, titleView, descriptionView, bulletOutView, bulletInView)
    }

    /**
     *  Populates data into schedule views
     *  @param data ScheduleSegment data to view
     *
     *  All other parameters are views related to Schedule which will be populated
     */
    fun populate(scheduleSegment: ScheduleSegment, timeRangeView: TextView
                 , titleView: TextView, descriptionView: TextView
                 , bulletOutView: ImageView, bulletInView: ImageView
    ) {
        val range = Utils.getTimeRange(scheduleSegment.startDayTime, scheduleSegment.endDayTime)
        timeRangeView.text = range
        titleView.text = scheduleSegment.title.value
        descriptionView.text = scheduleSegment.description.value

        val today = Calendar.getInstance()

        val isCurrent = today.time.after(scheduleSegment.startDayTime) && today.time.before(scheduleSegment.endDayTime)

        bulletOutView.setColorFilter(ContextCompat.getColor(bulletOutView.context, if (isCurrent) R.color.flybits_con_schedule_bullet_out_selected else R.color.flybits_con_schedule_bullet_out), android.graphics.PorterDuff.Mode.MULTIPLY)
        bulletInView.setColorFilter(ContextCompat.getColor(bulletInView.context, if (isCurrent) R.color.flybits_con_schedule_bullet_in_selected else R.color.flybits_con_schedule_bullet_in), android.graphics.PorterDuff.Mode.MULTIPLY)
    }

}