package com.flybits.concierge.viewpopulators

import android.text.TextUtils
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.request.RequestOptions
import com.flybits.concierge.R
import com.flybits.concierge.models.Onboarding
import com.flybits.concierge.models.OnboardingPage
import java.util.*

/**
 * Handles logic for adding data into onboarding related views
 */
class OnboardingViewPopulator {

    /**
     * Populates the given onboarding title into the title textview provided
     *
     * @param onboarding Onboarding data model to inject into the view
     * @param titleTextView view where Onboarding title will be added
     */
    fun populate(onboarding: Onboarding, titleTextView: TextView) {
        var onBoardingTitle: String? = null

        for (page in onboarding.onboardingPages.list) {
            if (!TextUtils.isEmpty(page.title.value)) {
                onBoardingTitle = page.title.value
                break
            }
        }

        val displayedTitle = String.format(Locale.getDefault(), titleTextView.context.getString(R.string.flybits_con_item_template_on_boarding_title_format), onBoardingTitle)

        titleTextView.text = displayedTitle
    }

    /**
     * Populates the given onboarding title into the title textview provided
     *
     * @param onboardingPage Onboarding data model
     * @param titleTextView Onboarding title view
     * @param bodyTextView body containing onboarding message
     * @param logoImageView image view containing company logo for onboarding
     *
     * The other parameters are views related to a particular onboarding object and will have data from @param onboarding
     * injected into them.
     *
     */
    fun populate(onboardingPage: OnboardingPage, titleTextView: TextView, bodyTextView: TextView, logoImageView: ImageView) {
        titleTextView.text = onboardingPage.title.value
        bodyTextView.text = onboardingPage.description.value

        val options = RequestOptions().format(DecodeFormat.PREFER_RGB_565)

        Glide.with(logoImageView.context)
            .load(onboardingPage.imageUrl)
            .apply(options)
            .into(logoImageView)
    }


}