package com.flybits.concierge.viewpopulators

import android.os.Bundle
import android.view.View
import android.widget.ImageView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.activities.ImageViewerActivity
import com.flybits.concierge.models.Images

/**
 * Handles logic for adding Images to UI
 *
 * @param contentAnalytics helps track analytics for content upon user interaction
 */
class ImagesViewPopulator(private val contentAnalytics: ContentAnalytics) {

    /**
     * Populate images data into views dedicated to images
     * @param images images data model to inject to UI
     * @param flybitsNavigator helps handle user interactions with content
     *
     * All other views {thisView, singleView, doubleView, multipleView, doubleImages, multipleImages, currentBoundImage}
     * are related to displaying different variations of images (single, double, multiple)
     */
    fun populate(images: Images, flybitsNavigator: FlybitsNavigator, thisView: View
                 , singleView: ImageView, doubleView: View, multipleView: View
                 , doubleImages: Array<ImageView>, multipleImages: Array<ImageView>
                 , currentBoundImage: Images){


        val onClickListener = View.OnClickListener { view ->
            contentAnalytics.trackEngaged(images.content.id)

            val extras = Bundle()
            extras.putParcelable(ImageViewerActivity.EXTRA_IMAGES, currentBoundImage.images)

            if (view == singleView) {
                extras.putInt(ImageViewerActivity.EXTRA_INDEX, 0)
                flybitsNavigator.openActivity(ImageViewerActivity::class.java, extras)
            } else {
                for (i in multipleImages.indices) {
                    if (i < doubleImages.size && view == doubleImages[i] || view == multipleImages[i]) {
                        extras.putInt(ImageViewerActivity.EXTRA_INDEX, i)
                        flybitsNavigator.openActivity(ImageViewerActivity::class.java, extras)
                        break
                    }
                }
            }
        }

        val imageViews: Array<ImageView>

        singleView.visibility = View.GONE
        doubleView.visibility = View.GONE
        multipleView.visibility = View.GONE

        val options = RequestOptions().centerCrop().format(DecodeFormat.PREFER_RGB_565)

        when (images.images.list.size) {
            1 -> {
                val image = images.images.list.get(0)
                singleView.visibility = View.VISIBLE

                Glide.with(thisView.context)
                    .load(image.url)
                    .apply(options)
                    .into(singleView)
                singleView.setOnClickListener(onClickListener)

                return
            }

            2 -> {
                imageViews = doubleImages
                doubleView.visibility = View.VISIBLE
            }

            else -> {
                imageViews = multipleImages
                multipleView.visibility = View.VISIBLE
            }
        }

        for (i in imageViews.indices) {
            val imgView = imageViews[i]
            Glide.with(thisView.context)
                .load(images.images.list.get(i).url)
                .apply(options)
                .into(imgView)
            imgView.setOnClickListener(onClickListener)
        }
    }

}