package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.ResourceProvider

/**
 * It’s a class that implements ViewModelProvider.Factory and it will create the ViewModel.
 */
class TransitionLoaderViewModelFactory(private val context: Context) : ViewModelProvider.Factory {
    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(TransitionLoaderViewModel::class.java)) {
            TransitionLoaderViewModel(
                FlybitsConcierge.with(context),
                ResourceProvider(context)
            ) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}