package com.flybits.concierge.models

import android.os.Parcel
import android.os.Parcelable
import com.flybits.android.kernel.models.LocalizedValue

/**
 * The {@link Details} class is used to define body parameter associated to
 * SimpleCard content template and ActionCard content template.
 */
class Details : Parcelable {

    var body: LocalizedValue? = null

    constructor() : super()

    constructor(parcel: Parcel) {
        body = parcel.readParcelable(LocalizedValue::class.java.classLoader)
    }

    override fun writeToParcel(dest: Parcel?, flags: Int) {
        dest?.let {
            dest.writeParcelable(body, flags)
        }
    }

    override fun describeContents(): Int = 0

    companion object CREATOR : Parcelable.Creator<Details> {
        override fun createFromParcel(parcel: Parcel): Details {
            return Details(parcel)
        }

        override fun newArray(size: Int): Array<Details?> {
            return arrayOfNulls(size)
        }
    }
}