package com.flybits.concierge.guidedoptin.presentation.view

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.support.v7.widget.LinearLayoutManager
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.TextView
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.guidedoptin.presentation.adapter.OptOutAdapter
import com.flybits.concierge.guidedoptin.presentation.model.OptOutResult
import com.flybits.concierge.guidedoptin.presentation.viewmodel.GuidedOptInViewModel
import kotlinx.android.synthetic.main.flybits_fragment_guided_opt_out.*

/**
 * This Fragment is responsible for Guided Opt Out UI.
 */
internal class OptOutFragment : Fragment() {

    private val viewModel: GuidedOptInViewModel by lazy {
        ViewModelProviders.of(activity!!).get(GuidedOptInViewModel::class.java)
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? = inflater.inflate(R.layout.flybits_fragment_guided_opt_out, container, false)

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val supportActionBarTitle: TextView? =
            activity?.findViewById(R.id.flybits_guided_toolbar_title)
        supportActionBarTitle?.text = getString(R.string.flybits_guided_opt_out_appbar_title)

        viewModel.getConciergeOptOut()?.let {
            flybits_opt_out_title.text = getString(it.title)
            flybits_opt_out_confirm.text = getString(it.confirmTitle)
            flybits_opt_out_cancel.text = getString(it.cancelTitle)

            if (it.info.isNotEmpty()) {
                flybits_opt_out_rv.apply {
                    layoutManager = LinearLayoutManager(context)
                    adapter = OptOutAdapter(it.info)
                    addItemDecoration(
                        MarginItemDecoration(
                            resources.getDimension(R.dimen.flybits_content_margin_xxlarge)
                                .toInt(), it.info.size
                        )
                    )
                }
            }
        }

        flybits_opt_out_confirm.setOnClickListener {
            InternalPreferences.setSelfUserOptedOut(context, true)
            flybits_opt_out_progress_bar.visibility = View.VISIBLE
            viewModel.optOut().observe(this, Observer<OptOutResult> {
                flybits_opt_out_progress_bar.visibility = View.GONE
                if (it?.success == false) {
                    if (activity != null) {
                        InternalPreferences.setSelfUserOptedOut(context, false)
                        context?.let { con ->
                            MaterialDialog.Builder(con)
                                .title(getString(R.string.flybits_opt_out_error_dialog_title))
                                .content(getString(R.string.flybits_opt_out_error_dialog_message))
                                .positiveText(R.string.flybits_con_ok)
                                .onPositive { dialog, _ -> dialog.dismiss() }
                                .show()
                        }
                    }
                } else {
                    viewModel.onOptOutCancelClicked()
                }
            })
        }

        flybits_opt_out_cancel.setOnClickListener {
            viewModel.onOptOutCancelClicked()
        }

    }

    companion object {
        fun newInstance() = OptOutFragment()
    }
}