package com.flybits.concierge.guidedoptin.presentation.view

import android.graphics.Rect
import android.support.v7.widget.RecyclerView
import android.view.View

/**
 * Recyclerview decorator responsible for adding margin to specific recyclerview items
 */
internal class MarginItemDecoration(private val margin: Int, private val itemCount: Int) : RecyclerView.ItemDecoration() {
    override fun getItemOffsets(
        outRect: Rect,
        view: View,
        parent: RecyclerView,
        state: RecyclerView.State
    ) {
        with(outRect) {
            if (parent.getChildAdapterPosition(view) != itemCount-1) {
                bottom = margin
            }
        }
    }
}