package com.flybits.concierge.guidedoptin.presentation.model

import com.flybits.concierge.R

/**
 * The model of Notifications data that is ready to be used in presentation layer by Views through ViewModels.
 */
internal data class NotificationsOptIn(
    val exclude: Boolean = false,
    val title: Int = R.string.flybits_guided_notification_title,
    val info: List<NotificationsOptInItem> = listOf(
        NotificationsOptInItem(
            R.drawable.flybits_guided_notifications_img_one,
            R.string.flybits_guided_notification_body_one
        ),
        NotificationsOptInItem(
            R.drawable.flybits_guided_notifications_img_two,
            R.string.flybits_guided_notification_body_three
        ),
        NotificationsOptInItem(
            R.drawable.flybits_guided_notifications_img_three,
            R.string.flybits_guided_notification_body_three
        )
    ),
    val disclaimerText: Int = R.string.flybits_guided_notification_disclaimer_text,
    val nextTitle: Int = R.string.flybits_guided_continue_text,
    val skipTitle: Int = R.string.flybits_guided_skip_text
)