package com.flybits.concierge.guidedoptin.presentation.model

import com.flybits.concierge.R

/**
 * The model of Location Services data that is ready to be used in presentation layer by Views through ViewModels.
 */
internal data class LocationOptIn (
    val exclude: Boolean = false,
    val title: Int = R.string.flybits_guided_location_title,
    val info: List<LocationOptInItem> = listOf(
        LocationOptInItem(
            R.drawable.flybits_guided_location_img_one,
            R.string.flybits_guided_location_body_one
        ),
        LocationOptInItem(
            R.drawable.flybits_guided_location_img_two,
            R.string.flybits_guided_location_body_two
        ),
        LocationOptInItem(
            R.drawable.flybits_guided_location_img_three,
            R.string.flybits_guided_location_body_three
        )
    ),
    val nextTitle: Int = R.string.flybits_guided_continue_text,
    val skipTitle: Int = R.string.flybits_guided_skip_text
)