package com.flybits.concierge.guidedoptin.presentation.model

import com.flybits.concierge.R

/**
 * The model of Benefits data that is ready to be used in presentation layer by Views through ViewModels.
 */
internal data class BenefitsOptIn(
    val title: Int = R.string.flybits_guided_benefits_title,
    val content: List<BenefitsOptInItem> = listOf(
        BenefitsOptInItem(
            R.drawable.flybits_guided_benefits_img_one,
            R.string.flybits_guided_benefits_body_one
        ),
        BenefitsOptInItem(
            R.drawable.flybits_guided_benefits_img_two,
            R.string.flybits_guided_benefits_body_two
        ),
        BenefitsOptInItem(
            R.drawable.flybits_guided_benefits_img_three,
            R.string.flybits_guided_benefits_body_three
        )
    ),
    val disclaimer: Int = R.string.flybits_guided_benefits_disclaimer,
    val disclaimerCheckBox: Boolean = true,
    val buttonTitle: Int = R.string.flybits_guided_continue_text
)