package com.flybits.concierge.guidedoptin

import java.lang.Exception

/**
 * Constant values that represent names of resources for Flybits' default string and drawable resources in res/values/strings.xml, res/values-fr-rCA/strings.xml and res/drawable/.
 */
// Benefits Opt In
const val TAG_BENEFITS = "BenefitsOptIn"
const val benefitsTitleDefault ="flybits_guided_benefits_title"
const val benefitsDisclaimerDefault = "flybits_guided_benefits_disclaimer"
const val benefitsBodyOneDefault = "flybits_guided_benefits_body_one"
const val benefitsBodyTwoDefault= "flybits_guided_benefits_body_two"
const val benefitsBodyThreeDefault = "flybits_guided_benefits_body_three"
const val benefitsImageOneDefault = "flybits_guided_benefits_img_one"
const val benefitsImageTwoDefault = "flybits_guided_benefits_img_two"
const val benefitsImageThreeDefault = "flybits_guided_benefits_img_three"

// Location Services
const val locationTitleDefault = "flybits_guided_location_title"
const val locationTitleFallbackDefault = "flybits_guided_location_title_fallback"
const val locationBodyOneDefault = "flybits_guided_location_body_one"
const val locationBodyTwoDefault = "flybits_guided_location_body_two"
const val locationBodyThreeDefault = "flybits_guided_location_body_three"
const val locationImageOneDefault = "flybits_guided_location_img_one"
const val locationImageTwoDefault = "flybits_guided_location_img_two"
const val locationImageThreeDefault = "flybits_guided_location_img_three"

// Notifications
const val notificationsTitleDefault = "flybits_guided_notification_title"
const val notificationsTitleFallbackDefault = "flybits_guided_notification_title_fallback"
const val notificationsBodyOneDefault = "flybits_guided_notification_body_one"
const val notificationsBodyTwoDefault = "flybits_guided_notification_body_two"
const val notificationsBodyThreeDefault = "flybits_guided_notification_body_three"
const val notificationsImageOneDefault = "flybits_guided_notification_img_one"
const val notificationsImageTwoDefault = "flybits_guided_notification_img_two"
const val notificationsImageThreeDefault = "flybits_guided_notification_img_three"
const val notificationsDisclaimerTextDefault = "flybits_guided_notification_disclaimer_text"

// Concierge Opt Out
const val conciergeOptOutTitleDefault = "flybits_guided_opt_out_title"
const val conciergeOptOutBodyOneDefault = "flybits_guided_opt_out_body_one"
const val conciergeOptOutBodyTwoDefault = "flybits_guided_opt_out_body_two"
const val conciergeOptOutBodyThreeDefault = "flybits_guided_opt_out_body_three"
const val conciergeOptOutImageOneDefault = "flybits_guided_opt_out_img_one"
const val conciergeOptOutImageTwoDefault = "flybits_guided_opt_out_img_two"
const val conciergeOptOutImageThreeDefault = "flybits_guided_opt_out_img_three"

// Common button titles
const val guidedContinueDefault ="flybits_guided_continue_text"
const val guidedSkipDefault ="flybits_guided_skip_text"
const val guidedEmptyString = "flybits_guided_empty_string"
const val guidedConfirmDefault ="flybits_con_opt_out"
const val guidedCancelDefault ="flybits_con_cancel"

const val UI_TRANSPARENT = 0.3f
/**
 * Function to log to system output when Android Log API should not be used.
 */
internal fun log(debug: Boolean = false, tag: String, message: String, e: Exception? = null) {
    if (debug) {
        if (e == null) {
            println("$tag: $message")
        } else {
            println("$tag: $message, $e")
        }
    }
}