package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.content.pm.ActivityInfo
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.flybits.concierge.FlybitsConcierge
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.viewmodels.OptInViewModel
import com.flybits.concierge.viewmodels.OptInViewModelFactory


/**
 * The Fragment is responsible for showing the Loading Screen till the [ConciergeConnectCallBack#connect] is called by the user.
 */
class TransitionLoaderFragment : Fragment() {

    internal val viewModel: OptInViewModel by lazy {
        ViewModelProviders.of(this, OptInViewModelFactory(context!!))
            .get(OptInViewModel::class.java)
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        InternalPreferences.setLaunchedFromGuidedOptInActivity(context, false)
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transition_loader, container, false)
    }

    override fun onResume() {
        super.onResume()
        context?.let { contextNotNull ->
            if (!InternalPreferences.isLaunchedFromGuidedOptInActivity(contextNotNull)) {
                arguments?.getBoolean("presentOptIn")?.let {
                    if (it) {
                        if (!InternalPreferences.isTwoPhaseConciergeFragment(contextNotNull)) {
                            FlybitsConcierge.with(contextNotNull)
                                .presentGuidedOptIn(requireContext())
                        } else {
                            viewModel.showOptOutConfirmationFragment()
                        }
                    }
                }
            } else {
                InternalPreferences.setLaunchedFromGuidedOptInActivity(contextNotNull, false)
                if (InternalPreferences.is2PhaseOptIn(contextNotNull)) {
                    viewModel.showOptOutConfirmationFragment()
                } else {
                    InternalPreferences.setOptOutConfirmationAdded(contextNotNull, false)
                    viewModel.optInOnOptOutConfirmation()
                }
            }
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        activity?.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_FULL_SENSOR
    }

    companion object {
        fun newInstance(presentOptIn: Boolean): TransitionLoaderFragment =
            TransitionLoaderFragment().apply {
                arguments = Bundle().apply {
                    putBoolean("presentOptIn", presentOptIn)
                }
            }
    }
}
