package com.flybits.concierge.fragments

import android.graphics.Color
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.webkit.WebView
import android.widget.ImageView
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.commons.library.utils.Utilities
import com.flybits.concierge.R
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.models.SimpleCard
import com.flybits.concierge.utils.setStreamLineWebViewStyle


/**
 * A simple [Fragment] subclass.
 * Use the [SimpleCardDetailFragment.newInstance] factory method to
 * create an instance of this fragment.
 */
class SimpleCardDetailFragment : Fragment() {

    private var simpleCard: SimpleCard? = null
    private var contentAnalytics: ContentAnalytics? = null
    private var userActionHandler: UserActionHandler<SimpleCard>? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            simpleCard = it.getParcelable(ARG_SIMPLECARD)
            userActionHandler = it.getParcelable(ARG_USER_ACTION_HANDLER)
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_streamline_link_detail, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        val bannerView: ImageView =
            view.findViewById(R.id.flybits_streamline_detail_imageHeader)
        val headerView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_header)
        val titleView: TextView =
            view.findViewById(R.id.flybits_streamline_detail_title)
        val bodyView: WebView =
            view.findViewById(R.id.flybits_streamline_detail_body)
        val descriptionView: WebView =
            view.findViewById(R.id.flybits_streamline_detail_description)

        simpleCard?.image?.value.let {
            if (it.isNullOrEmpty()) {
                bannerView.visibility = View.GONE
            } else {
                Glide.with(bannerView.context).load(it)
                    .apply(RequestOptions().centerCrop()).into(bannerView)
            }
        }

        simpleCard?.header?.value.let {
            if (it.isNullOrEmpty()) {
                headerView.visibility = View.GONE
            } else {
                headerView.text = it
            }
        }

        titleView.text = simpleCard?.title?.value

        simpleCard?.description?.value.let {
            if (it.isNullOrEmpty()) {
                descriptionView.visibility = View.GONE
            } else {
                val rtf = Utilities.toRTF(it)
                descriptionView.loadDataWithBaseURL(
                    null,
                    setStreamLineWebViewStyle(
                        rtf,
                        descriptionView.context,
                        R.style.Concierge_StreamLined_Detail_Link_Description
                    ),
                    "text/html",
                    "UTF-8",
                    null
                )
                descriptionView.setBackgroundColor(Color.TRANSPARENT)
                descriptionView.isVerticalScrollBarEnabled = false
            }
        }

        simpleCard?.details?.body?.value.let {
            if (it.isNullOrEmpty()) {
                bodyView.visibility = View.GONE
            } else {
                val rtf = Utilities.toRTF(it)
                bodyView.loadDataWithBaseURL(
                    null,
                    setStreamLineWebViewStyle(
                        rtf,
                        descriptionView.context,
                        R.style.Concierge_StreamLined_Detail_Link_Body
                    ),
                    "text/html",
                    "UTF-8",
                    null
                )
                bodyView.setBackgroundColor(Color.TRANSPARENT)
                bodyView.isVerticalScrollBarEnabled = false
            }
        }
    }


    companion object {
        private const val ARG_SIMPLECARD = "arg_simplecard"
        private const val ARG_USER_ACTION_HANDLER = "arg_user_action_handler"

        @JvmStatic
        fun newInstance(
            simpleCard: SimpleCard,
            userActionHandler: UserActionHandler<SimpleCard>
        ) =
            SimpleCardDetailFragment().apply {
                arguments = Bundle().apply {
                    putParcelable(ARG_SIMPLECARD, simpleCard)
                    putParcelable(ARG_USER_ACTION_HANDLER, userActionHandler)
                }
            }
    }
}
