package com.flybits.concierge.enums;

public enum QuestionUIType
{
    SHORT("shortAnswer"),
    LONG("longAnswer"),
    NUMBER("number"),
    MULTIPLE("multipleChoice"),
    CHECK("checkboxes"),
    DROPDOWN("dropdown"),
    DATE("date"),
    TIME("time"),
    LOCATION("location"),
    FILE("fileUpload"),
    UNKNOWN("unknown");

    QuestionUIType(String text)
    {
        this.text = text;
    }

    private String text;

    public static QuestionUIType fromString(String text)
    {
        for (QuestionUIType type : QuestionUIType.values())
        {
            if (type.text.contentEquals(text))
            {
                return type;
            }
        }

        return UNKNOWN;
    }

    public static final String ARG_JSON_KEY_UI_TYPE = "uiType";
}
