/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.views;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.AutoCompleteTextView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.adapters.PlaceAutocompleteAdapter;
import com.flybits.concierge.views.SurveyBaseView;
import com.google.android.gms.location.places.AutocompletePrediction;
import com.google.android.gms.location.places.GeoDataClient;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import org.json.JSONException;
import org.json.JSONObject;

public class SurveyLocation
extends SurveyBaseView {
    private static final LatLngBounds LAT_LNG_BOUNDS = new LatLngBounds(new LatLng(-40.0, -168.0), new LatLng(70.0, 136.0));
    private static final String KEY_ID = "id";
    private static final String KEY_NAME = "name";
    private AutoCompleteTextView autoTextView;
    private PlaceAutocompleteAdapter autocompleteAdapter;
    private JSONObject jsonObject;
    private TextView headerTextView;
    private TextView locationTextView;
    private TextView noApiTextView;
    private AdapterView.OnItemClickListener itemClickListener = new AdapterView.OnItemClickListener(){

        public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
            AutocompletePrediction item = SurveyLocation.this.autocompleteAdapter.getItem(position);
            CharSequence locationName = item.getFullText(null);
            String locationId = item.getPlaceId();
            try {
                SurveyLocation.this.jsonObject = new JSONObject();
                SurveyLocation.this.jsonObject.put(SurveyLocation.KEY_ID, (Object)locationId);
                SurveyLocation.this.jsonObject.put(SurveyLocation.KEY_NAME, (Object)locationName);
            }
            catch (JSONException e) {
                SurveyLocation.this.jsonObject = null;
                Logger.exception((String)SurveyLocation.class.getSimpleName(), (Exception)((Object)e));
            }
            SurveyLocation.this.setLocationText();
            SurveyLocation.this.callOnClick();
        }
    };

    public SurveyLocation(Context context, String json) {
        super(context);
        if (!TextUtils.isEmpty((CharSequence)json)) {
            try {
                this.jsonObject = new JSONObject(json);
            }
            catch (JSONException e) {
                Logger.exception((String)SurveyLocation.class.getSimpleName(), (Exception)((Object)e));
            }
        }
        this.init(null, 0);
    }

    public SurveyLocation(Context context) {
        super(context);
        this.init(null, 0);
    }

    public SurveyLocation(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs, 0);
    }

    public SurveyLocation(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        LayoutInflater inflater = (LayoutInflater)this.getContext().getSystemService("layout_inflater");
        View view = inflater.inflate(R.layout.flybits_con_view_survey_location, (ViewGroup)this, true);
        this.noApiTextView = (TextView)view.findViewById(R.id.flybits_con_view_survey_location_no_key);
        this.autoTextView = (AutoCompleteTextView)view.findViewById(R.id.flybits_con_view_survey_location_autocomplete_txtView);
        this.headerTextView = (TextView)view.findViewById(R.id.flybits_con_view_survey_location_header);
        this.locationTextView = (TextView)view.findViewById(R.id.flybits_con_view_survey_location_text);
        GeoDataClient geoDataClient = Places.getGeoDataClient((Context)this.getContext());
        this.autocompleteAdapter = new PlaceAutocompleteAdapter(this.getContext(), geoDataClient, LAT_LNG_BOUNDS, null);
        this.autoTextView.setAdapter((ListAdapter)this.autocompleteAdapter);
        this.autoTextView.setOnItemClickListener(this.itemClickListener);
        try {
            ApplicationInfo ai = this.getContext().getPackageManager().getApplicationInfo(this.getContext().getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String googleApiKey = bundle.getString("com.google.android.geo.API_KEY");
            if (TextUtils.isEmpty((CharSequence)googleApiKey)) {
                this.noGoogleKey();
            }
        }
        catch (Exception e) {
            this.noGoogleKey();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.setLocationText();
        if (this.jsonObject != null) {
            try {
                this.autoTextView.setText((CharSequence)this.jsonObject.getString(KEY_NAME));
            }
            catch (JSONException e) {
                Logger.exception((String)SurveyLocation.class.getSimpleName(), (Exception)((Object)e));
            }
        }
    }

    private void setLocationText() {
        this.headerTextView.setVisibility(8);
        this.locationTextView.setVisibility(8);
        if (this.jsonObject != null) {
            this.headerTextView.setVisibility(0);
            this.locationTextView.setVisibility(0);
            try {
                this.locationTextView.setText((CharSequence)this.jsonObject.getString(KEY_NAME));
            }
            catch (JSONException e) {
                this.locationTextView.setText((CharSequence)"--");
                Logger.exception((String)SurveyLocation.class.getSimpleName(), (Exception)((Object)e));
            }
        }
    }

    private void noGoogleKey() {
        this.autoTextView.setVisibility(8);
        this.noApiTextView.setVisibility(0);
    }

    @Override
    public Object getAnswer() {
        return this.jsonObject != null ? this.jsonObject.toString() : null;
    }
}

