/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.arch.lifecycle.ViewModelProviders;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.flybits.android.kernel.reservedtemplates.survey.models.Question;
import com.flybits.android.kernel.reservedtemplates.survey.models.QuestionChoice;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.R;
import com.flybits.concierge.enums.QuestionUIType;
import com.flybits.concierge.viewmodels.SurveyViewModel;
import com.flybits.concierge.views.SurveyBaseView;
import com.flybits.concierge.views.SurveyDate;
import com.flybits.concierge.views.SurveyDropDown;
import com.flybits.concierge.views.SurveyFile;
import com.flybits.concierge.views.SurveyLocation;
import com.flybits.concierge.views.SurveyLongAnswer;
import com.flybits.concierge.views.SurveyMultipleChoice;
import com.flybits.concierge.views.SurveyNumber;
import com.flybits.concierge.views.SurveyShortAnswer;
import com.flybits.concierge.views.SurveyTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;

public class QuestionFragment
extends Fragment {
    private static final String ARG_QUESTION = "flybits_con_arg_question";
    private static final String ARG_NUMBER = "flybits_con_arg_number";
    private Question question;
    private int number;
    private boolean required;
    private QuestionUIType uiType;
    private LinearLayout containerView;
    private View.OnClickListener clickListener;
    private SurveyViewModel viewModel;

    public static QuestionFragment newInstance(Question question, int number) {
        QuestionFragment fragment = new QuestionFragment();
        Bundle args = new Bundle();
        args.putParcelable(ARG_QUESTION, (Parcelable)question);
        args.putInt(ARG_NUMBER, number);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.question = (Question)this.getArguments().getParcelable(ARG_QUESTION);
            this.number = this.getArguments().getInt(ARG_NUMBER);
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.flybits_con_fragment_question, container, false);
    }

    public void onViewCreated(@NonNull View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        TextView questionNumberView = (TextView)view.findViewById(R.id.flybits_con_fragment_question_txtQuestionNumber);
        questionNumberView.setText((CharSequence)String.format(Locale.getDefault(), this.getString(R.string.flybits_con_fragment_question_question_format), this.number));
        TextView questionView = (TextView)view.findViewById(R.id.flybits_con_fragment_question_txtQuestion);
        questionView.setText((CharSequence)this.question.question.getValue());
        this.containerView = (LinearLayout)view.findViewById(R.id.flybits_con_fragment_question_lytQuestionContainer);
        this.clickListener = new View.OnClickListener(){

            public void onClick(View v) {
                QuestionFragment.this.populateAnswer();
            }
        };
        this.viewModel = (SurveyViewModel)ViewModelProviders.of((FragmentActivity)this.getActivity()).get(SurveyViewModel.class);
        String uiTypeKey = "unknown";
        try {
            uiTypeKey = this.question.getMetadata().getString("uiType");
            this.required = this.question.getMetadata().getBoolean("isRequired");
        }
        catch (Exception e) {
            Logger.exception((String)QuestionFragment.class.getSimpleName(), (Exception)e);
        }
        this.uiType = QuestionUIType.fromString(uiTypeKey);
        TextView requiredView = (TextView)view.findViewById(R.id.flybits_con_fragment_question_txtRequired);
        requiredView.setVisibility(this.required ? 0 : 8);
        this.configureAnswer();
    }

    private void configureAnswer() {
        Object answer = this.viewModel.getAnswers().get(this.question.questionNumber.longValue());
        this.containerView.removeAllViews();
        switch (this.uiType) {
            case SHORT: {
                this.containerView.addView((View)new SurveyShortAnswer(this.getContext(), answer instanceof String ? answer.toString() : null));
                break;
            }
            case LONG: {
                this.containerView.addView((View)new SurveyLongAnswer(this.getContext(), answer instanceof String ? answer.toString() : null));
                break;
            }
            case CHECK: {
                List selections = answer instanceof List ? (List)answer : null;
                for (int i = 0; i < this.question.choices.size(); ++i) {
                    QuestionChoice choice = (QuestionChoice)this.question.choices.get(i);
                    CheckBox box = (CheckBox)this.getLayoutInflater().inflate(R.layout.flybits_con_view_survey_check_box, (ViewGroup)this.containerView, false);
                    box.setText((CharSequence)choice.value.getValue());
                    box.setId(i + 100);
                    this.containerView.addView((View)box);
                    if (selections == null || box.isChecked()) continue;
                    box.setChecked(selections.contains(i));
                }
                break;
            }
            case MULTIPLE: {
                this.containerView.addView((View)new SurveyMultipleChoice(this.getContext(), this.question.choices, answer instanceof Integer ? (Integer)answer : -1));
                break;
            }
            case DROPDOWN: {
                this.containerView.addView((View)new SurveyDropDown(this.getContext(), this.question.choices, answer instanceof Integer ? (Integer)answer : -1));
                break;
            }
            case NUMBER: {
                this.containerView.addView((View)new SurveyNumber(this.getContext(), answer instanceof Long ? (Long)answer : -1L));
                break;
            }
            case DATE: {
                this.containerView.addView((View)new SurveyDate(this.getContext(), this.getActivity().getFragmentManager(), answer instanceof Calendar ? (Calendar)answer : null));
                break;
            }
            case TIME: {
                this.containerView.addView((View)new SurveyTime(this.getContext(), this.getActivity().getFragmentManager(), answer instanceof Calendar ? (Calendar)answer : null));
                break;
            }
            case LOCATION: {
                this.containerView.addView((View)new SurveyLocation(this.getContext(), answer instanceof String ? answer.toString() : null));
                break;
            }
            case FILE: {
                this.containerView.addView((View)new SurveyFile(this.getContext()));
                break;
            }
            default: {
                TextView unsupported = new TextView(this.getContext());
                unsupported.setText(R.string.flybits_con_view_currently_not_supported);
                this.containerView.addView((View)unsupported);
            }
        }
        for (int i = 0; i < this.containerView.getChildCount(); ++i) {
            this.containerView.getChildAt(i).setOnClickListener(this.clickListener);
        }
    }

    private void populateAnswer() {
        ArrayList<Integer> selections = new ArrayList<Integer>();
        for (int i = 0; i < this.containerView.getChildCount(); ++i) {
            View view = this.containerView.getChildAt(i);
            if (view instanceof CheckBox) {
                CheckBox checkBox = (CheckBox)view;
                if (!checkBox.isChecked()) continue;
                selections.add(i);
                continue;
            }
            if (!(view instanceof SurveyBaseView)) continue;
            Object answer = ((SurveyBaseView)view).getAnswer();
            if (answer == null) {
                this.viewModel.getAnswers().remove(this.question.questionNumber.longValue());
            } else {
                this.viewModel.getAnswers().put(this.question.questionNumber.longValue(), answer);
            }
            return;
        }
        if (!selections.isEmpty()) {
            this.viewModel.getAnswers().put(this.question.questionNumber.longValue(), selections);
        } else {
            this.viewModel.getAnswers().remove(this.question.questionNumber.longValue());
        }
    }
}

