/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewpopulators;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.os.Parcelable;
import android.text.SpannableString;
import android.text.TextUtils;
import android.text.style.UnderlineSpan;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.Utils;
import com.flybits.concierge.activities.EventDetailsActivity;
import com.flybits.concierge.models.Event;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010Jl\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0012\u001a\u0004\u0018\u00010\n2\b\u0010\u0013\u001a\u0004\u0018\u00010\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\n2\b\u0010\u0015\u001a\u0004\u0018\u00010\n\u00a8\u0006\u0016"}, d2={"Lcom/flybits/concierge/viewpopulators/EventsViewPopulator;", "", "()V", "populate", "", "data", "Lcom/flybits/concierge/models/Event;", "flybitsNavigator", "Lcom/flybits/concierge/FlybitsNavigator;", "titleView", "Landroid/widget/TextView;", "locationView", "dateView", "imgHeader", "Landroid/widget/ImageView;", "eventView", "Landroid/view/View;", "event", "addressView", "ctaView", "phoneView", "descriptionView", "concierge_release"})
public final class EventsViewPopulator {
    public final void populate(@NotNull Event event, @Nullable FlybitsNavigator flybitsNavigator, @Nullable TextView titleView, @NotNull TextView locationView, @NotNull TextView dateView, @NotNull ImageView imgHeader, @Nullable View eventView, @Nullable TextView addressView, @Nullable TextView ctaView, @Nullable TextView phoneView, @Nullable TextView descriptionView) {
        block15: {
            SpannableString content;
            CharSequence charSequence;
            Intrinsics.checkParameterIsNotNull((Object)event, (String)"event");
            Intrinsics.checkParameterIsNotNull((Object)locationView, (String)"locationView");
            Intrinsics.checkParameterIsNotNull((Object)dateView, (String)"dateView");
            Intrinsics.checkParameterIsNotNull((Object)imgHeader, (String)"imgHeader");
            BaseRequestOptions baseRequestOptions = ((RequestOptions)new RequestOptions().centerCrop()).format(DecodeFormat.PREFER_RGB_565);
            Intrinsics.checkExpressionValueIsNotNull((Object)baseRequestOptions, (String)"RequestOptions().centerC\u2026odeFormat.PREFER_RGB_565)");
            RequestOptions options = (RequestOptions)baseRequestOptions;
            Glide.with((Context)imgHeader.getContext()).load(event.coverPhotoURL).apply((BaseRequestOptions)options).into(imgHeader);
            TextView textView = titleView;
            if (textView != null) {
                CharSequence charSequence2;
                LocalizedValue localizedValue = event.title;
                Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue, (String)"event.title");
                if (!TextUtils.isEmpty((CharSequence)localizedValue.getValue())) {
                    LocalizedValue localizedValue2 = event.title;
                    Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue2, (String)"event.title");
                    charSequence2 = localizedValue2.getValue();
                } else {
                    charSequence2 = "";
                }
                textView.setText(charSequence2);
            }
            LocalizedValue localizedValue = event.venueDescription;
            Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue, (String)"event.venueDescription");
            if (!TextUtils.isEmpty((CharSequence)localizedValue.getValue())) {
                LocalizedValue localizedValue3 = event.venueDescription;
                Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue3, (String)"event.venueDescription");
                charSequence = localizedValue3.getValue();
            } else {
                charSequence = "";
            }
            locationView.setText(charSequence);
            dateView.setText((CharSequence)Utils.getDateRange(event.getStartDate(), event.getEndDate()));
            if (eventView != null && flybitsNavigator != null) {
                eventView.setOnClickListener(new View.OnClickListener(event, flybitsNavigator){
                    final /* synthetic */ Event $event;
                    final /* synthetic */ FlybitsNavigator $flybitsNavigator;

                    public final void onClick(View it) {
                        Bundle extras = new Bundle();
                        extras.putParcelable("flybits_con_extra_event_details", (Parcelable)this.$event);
                        this.$flybitsNavigator.openActivity(EventDetailsActivity.class, extras);
                    }
                    {
                        this.$event = event;
                        this.$flybitsNavigator = flybitsNavigator;
                    }
                });
            }
            if (addressView != null) {
                if (descriptionView != null) {
                    content = new SpannableString((CharSequence)event.address);
                    content.setSpan((Object)new UnderlineSpan(), 0, content.length(), 0);
                    addressView.setText((CharSequence)content);
                } else {
                    addressView.setText((CharSequence)event.address);
                }
            }
            if (ctaView != null) {
                ctaView.setVisibility(!TextUtils.isEmpty((CharSequence)event.url) ? 0 : 4);
                ctaView.setOnClickListener(new View.OnClickListener(event){
                    final /* synthetic */ Event $event;

                    public final void onClick(View v) {
                        String url = this.$event.url;
                        Intent intent = new Intent("android.intent.action.VIEW");
                        intent.setData(Uri.parse((String)url));
                        View view = v;
                        Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
                        view.getContext().startActivity(intent);
                    }
                    {
                        this.$event = event;
                    }
                });
            }
            if (phoneView != null) {
                if (!TextUtils.isEmpty((CharSequence)event.phoneNumber)) {
                    if (descriptionView != null) {
                        content = new SpannableString((CharSequence)event.phoneNumber);
                        content.setSpan((Object)new UnderlineSpan(), 0, content.length(), 0);
                        phoneView.setText((CharSequence)content);
                    } else {
                        phoneView.setText((CharSequence)event.phoneNumber);
                    }
                } else {
                    phoneView.setText(17039374);
                }
            }
            TextView textView2 = descriptionView;
            if (textView2 == null) break block15;
            LocalizedValue localizedValue4 = event.description;
            Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue4, (String)"event.description");
            textView2.setText((CharSequence)localizedValue4.getValue());
        }
    }

    public final void populate(@NotNull Event data, @NotNull FlybitsNavigator flybitsNavigator, @NotNull TextView titleView, @NotNull TextView locationView, @NotNull TextView dateView, @NotNull ImageView imgHeader, @NotNull View eventView) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)flybitsNavigator, (String)"flybitsNavigator");
        Intrinsics.checkParameterIsNotNull((Object)titleView, (String)"titleView");
        Intrinsics.checkParameterIsNotNull((Object)locationView, (String)"locationView");
        Intrinsics.checkParameterIsNotNull((Object)dateView, (String)"dateView");
        Intrinsics.checkParameterIsNotNull((Object)imgHeader, (String)"imgHeader");
        Intrinsics.checkParameterIsNotNull((Object)eventView, (String)"eventView");
        this.populate(data, flybitsNavigator, titleView, locationView, dateView, imgHeader, eventView, null, null, null, null);
    }
}

