/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.viewpopulators;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.DecodeFormat;
import com.bumptech.glide.request.BaseRequestOptions;
import com.bumptech.glide.request.RequestOptions;
import com.flybits.android.kernel.ContentAnalytics;
import com.flybits.android.kernel.models.Content;
import com.flybits.android.kernel.models.LocalizedValue;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.commons.library.logging.Logger;
import com.flybits.concierge.adapters.ArticleAdapter;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.models.Articles;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J>\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015JF\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015R\u0014\u0010\u0005\u001a\u00020\u0006X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/flybits/concierge/viewpopulators/ArticlesViewPopulator;", "", "contentAnalytics", "Lcom/flybits/android/kernel/ContentAnalytics;", "(Lcom/flybits/android/kernel/ContentAnalytics;)V", "TAG", "", "getTAG", "()Ljava/lang/String;", "populate", "", "article", "Lcom/flybits/concierge/models/Article;", "contentId", "imgHeader", "Landroid/widget/ImageView;", "txtTitle", "Landroid/widget/TextView;", "txtSource", "txtDescription", "thisView", "Landroid/view/View;", "data", "Lcom/flybits/concierge/models/Articles;", "viewPager", "Landroid/support/v4/view/ViewPager;", "singleView", "concierge_release"})
public final class ArticlesViewPopulator {
    @NotNull
    private final String TAG = "ArtiViewPop";
    private final ContentAnalytics contentAnalytics;

    @NotNull
    public final String getTAG() {
        return this.TAG;
    }

    public final void populate(@NotNull Article article, @NotNull String contentId, @NotNull ImageView imgHeader, @NotNull TextView txtTitle, @NotNull TextView txtSource, @NotNull TextView txtDescription, @NotNull View thisView) {
        Intrinsics.checkParameterIsNotNull((Object)article, (String)"article");
        Intrinsics.checkParameterIsNotNull((Object)contentId, (String)"contentId");
        Intrinsics.checkParameterIsNotNull((Object)imgHeader, (String)"imgHeader");
        Intrinsics.checkParameterIsNotNull((Object)txtTitle, (String)"txtTitle");
        Intrinsics.checkParameterIsNotNull((Object)txtSource, (String)"txtSource");
        Intrinsics.checkParameterIsNotNull((Object)txtDescription, (String)"txtDescription");
        Intrinsics.checkParameterIsNotNull((Object)thisView, (String)"thisView");
        BaseRequestOptions baseRequestOptions = new RequestOptions().format(DecodeFormat.PREFER_RGB_565);
        Intrinsics.checkExpressionValueIsNotNull((Object)baseRequestOptions, (String)"RequestOptions().format(\u2026odeFormat.PREFER_RGB_565)");
        RequestOptions options = (RequestOptions)baseRequestOptions;
        Glide.with((Context)imgHeader.getContext()).load(article.imageURL).apply((BaseRequestOptions)options).into(imgHeader);
        LocalizedValue localizedValue = article.title;
        Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue, (String)"article.title");
        txtTitle.setText((CharSequence)localizedValue.getValue());
        txtSource.setVisibility(!TextUtils.isEmpty((CharSequence)article.sourceName) ? 0 : 4);
        txtSource.setText((CharSequence)article.sourceName);
        LocalizedValue localizedValue2 = article.description;
        Intrinsics.checkExpressionValueIsNotNull((Object)localizedValue2, (String)"article.description");
        txtDescription.setText((CharSequence)localizedValue2.getValue());
        thisView.setOnClickListener(new View.OnClickListener(this, contentId, article){
            final /* synthetic */ ArticlesViewPopulator this$0;
            final /* synthetic */ String $contentId;
            final /* synthetic */ Article $article;

            public final void onClick(View v) {
                ContentAnalytics.trackEngaged$default((ContentAnalytics)ArticlesViewPopulator.access$getContentAnalytics$p(this.this$0), (String)this.$contentId, (long)0L, (int)2, null);
                ContentAnalytics.trackFulfilled$default((ContentAnalytics)ArticlesViewPopulator.access$getContentAnalytics$p(this.this$0), (String)this.$contentId, (long)0L, (int)2, null);
                String url = this.$article.url;
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                View view = v;
                Intrinsics.checkExpressionValueIsNotNull((Object)view, (String)"v");
                Context context = view.getContext();
                Intrinsics.checkExpressionValueIsNotNull((Object)context, (String)"v.context");
                if (intent.resolveActivity(context.getPackageManager()) != null) {
                    v.getContext().startActivity(intent);
                } else {
                    Logger.appendTag((String)this.this$0.getTAG()).e("Invalid url for Article");
                }
            }
            {
                this.this$0 = articlesViewPopulator;
                this.$contentId = string2;
                this.$article = article;
            }
        });
    }

    public final void populate(@NotNull Articles data, @NotNull ViewPager viewPager, @NotNull View singleView, @NotNull ImageView imgHeader, @NotNull TextView txtTitle, @NotNull TextView txtSource, @NotNull TextView txtDescription, @NotNull View thisView) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        Intrinsics.checkParameterIsNotNull((Object)viewPager, (String)"viewPager");
        Intrinsics.checkParameterIsNotNull((Object)singleView, (String)"singleView");
        Intrinsics.checkParameterIsNotNull((Object)imgHeader, (String)"imgHeader");
        Intrinsics.checkParameterIsNotNull((Object)txtTitle, (String)"txtTitle");
        Intrinsics.checkParameterIsNotNull((Object)txtSource, (String)"txtSource");
        Intrinsics.checkParameterIsNotNull((Object)txtDescription, (String)"txtDescription");
        Intrinsics.checkParameterIsNotNull((Object)thisView, (String)"thisView");
        viewPager.setVisibility(8);
        singleView.setVisibility(8);
        PagedArray<Article> pagedArray = data.articles;
        Intrinsics.checkExpressionValueIsNotNull(pagedArray, (String)"data.articles");
        ArrayList articleList = pagedArray.getList();
        if (articleList.size() > 1) {
            viewPager.setVisibility(0);
            ArticleAdapter adapter = new ArticleAdapter(this);
            viewPager.setAdapter((PagerAdapter)adapter);
            PagedArray<Article> pagedArray2 = data.articles;
            Intrinsics.checkExpressionValueIsNotNull(pagedArray2, (String)"data.articles");
            List list = pagedArray2.getList();
            Content content = data.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"data.content");
            adapter.setData(list, content.getId());
        } else if (articleList.size() == 1) {
            singleView.setVisibility(0);
            Object e = articleList.get(0);
            Intrinsics.checkExpressionValueIsNotNull(e, (String)"articleList[0]");
            Article article = (Article)e;
            Content content = data.getContent();
            Intrinsics.checkExpressionValueIsNotNull((Object)content, (String)"data.content");
            String string2 = content.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"data.content.id");
            this.populate(article, string2, imgHeader, txtTitle, txtSource, txtDescription, thisView);
        }
    }

    public ArticlesViewPopulator(@NotNull ContentAnalytics contentAnalytics) {
        Intrinsics.checkParameterIsNotNull((Object)contentAnalytics, (String)"contentAnalytics");
        this.contentAnalytics = contentAnalytics;
        this.TAG = "ArtiViewPop";
    }

    public static final /* synthetic */ ContentAnalytics access$getContentAnalytics$p(ArticlesViewPopulator $this) {
        return $this.contentAnalytics;
    }
}

