/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.fragments;

import android.content.Context;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.TextView;
import com.flybits.android.kernel.models.PagedArray;
import com.flybits.concierge.R;
import com.flybits.concierge.activities.ImageViewerActivity;
import com.flybits.concierge.fragments.ImageFragment;
import com.flybits.concierge.models.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class ImageViewerPagerFragment
extends Fragment {
    PagedArray<Image> images;
    ViewPager pgrPager;
    PagerAdapter adapter;
    TextView txtCounter;

    public static ImageViewerPagerFragment newInstance(PagedArray<Image> imageList, int startIndex) {
        ImageViewerPagerFragment frag = new ImageViewerPagerFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("list", imageList);
        bundle.putInt("start", startIndex);
        frag.setArguments(bundle);
        return frag;
    }

    @Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @Nullable ViewGroup container, Bundle savedInstanceState) {
        View v = inflater.inflate(R.layout.flybits_con_fragment_imageviewerpager, container, false);
        this.pgrPager = (ViewPager)v.findViewById(R.id.flybits_con_fragment_imageviewpager_pgrImages);
        this.txtCounter = (TextView)v.findViewById(R.id.flybits_con_fragment_imageviewpager_txtIndex);
        PagedArray<Image> pagedArray = this.images = this.getArguments() != null ? (PagedArray<Image>)this.getArguments().getParcelable("list") : null;
        if (this.images == null) {
            return v;
        }
        this.adapter = new PagerAdapter((Context)this.getActivity(), this.getFragmentManager(), this.images.getList());
        this.pgrPager.setAdapter((android.support.v4.view.PagerAdapter)this.adapter);
        int index = this.getArguments().getInt("start", 0);
        this.pgrPager.setCurrentItem(index);
        this.getActivity().setTitle((CharSequence)((Image)this.images.getList().get((int)index)).title.getValue());
        this.pgrPager.addOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
            }

            public void onPageSelected(int position) {
                ImageViewerPagerFragment.this.setCounter(position + 1, ImageViewerPagerFragment.this.images.getList().size());
                FragmentActivity activity = ImageViewerPagerFragment.this.getActivity();
                if (activity instanceof ImageViewerActivity) {
                    activity.setTitle((CharSequence)((Image)ImageViewerPagerFragment.this.images.getList().get((int)position)).title.getValue());
                }
            }

            public void onPageScrollStateChanged(int state) {
            }
        });
        this.setCounter(this.pgrPager.getCurrentItem() + 1, this.images.getList().size());
        return v;
    }

    private void setCounter(int current, int max) {
        this.txtCounter.setText((CharSequence)String.format(Locale.getDefault(), "%d/%d", current, max));
    }

    static class PagerAdapter
    extends FragmentStatePagerAdapter {
        Context context;
        List<Image> images;

        PagerAdapter(Context context, FragmentManager fm, ArrayList<Image> images) {
            super(fm);
            this.context = context;
            this.images = images;
        }

        public Fragment getItem(int position) {
            return ImageFragment.newInstance(this.images.get((int)position).url, false, false, 0);
        }

        public int getCount() {
            return this.images.size();
        }
    }
}

