/*
 * Decompiled with CFR 0.152.
 */
package com.flybits.concierge.adapters;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.view.PagerAdapter;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Article;
import com.flybits.concierge.viewpopulators.ArticlesViewPopulator;
import java.util.ArrayList;
import java.util.List;

public class ArticleAdapter
extends PagerAdapter {
    private List<Article> data;
    private String parentContentId = "";
    private ArticlesViewPopulator articlesViewPopulator;

    public ArticleAdapter(ArticlesViewPopulator articlesViewPopulator) {
        this.articlesViewPopulator = articlesViewPopulator;
        this.data = new ArrayList<Article>();
    }

    public void setData(List<Article> data, String parentContentId) {
        this.data = data;
        this.parentContentId = parentContentId;
        this.notifyDataSetChanged();
    }

    @NonNull
    public Object instantiateItem(@NonNull ViewGroup container, int position) {
        View itemView = LayoutInflater.from((Context)container.getContext()).inflate(R.layout.flybits_con_item_article, container, false);
        container.addView(itemView);
        Article article = this.data.get(position);
        TextView title = (TextView)itemView.findViewById(R.id.flybits_con_article_txtTitle);
        TextView description = (TextView)itemView.findViewById(R.id.flybits_con_article_txtDescription);
        TextView source = (TextView)itemView.findViewById(R.id.flybits_con_article_txtSource);
        ImageView imageView = (ImageView)itemView.findViewById(R.id.flybits_con_article_imgHeader);
        this.articlesViewPopulator.populate(article, this.parentContentId, imageView, title, source, description, itemView);
        return itemView;
    }

    public int getCount() {
        return this.data.size();
    }

    public boolean isViewFromObject(@NonNull View view, @NonNull Object object) {
        return view == object;
    }

    public void destroyItem(@NonNull ViewGroup container, int position, @NonNull Object object) {
        container.removeView((View)object);
    }
}

