package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import android.arch.lifecycle.ViewModelProvider
import android.content.Context
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.FlybitsViewProviderGetter
import com.flybits.concierge.repository.ModelConverter
import com.flybits.concierge.repository.content.ContentGetter
import com.flybits.concierge.repository.push.NotificationContentRepository
import com.flybits.concierge.repository.push.PushGetter

class NotificationsViewModelFactory(context: Context, private val flybitsViewProviderGetter: FlybitsViewProviderGetter, private val flybitsNavigator: FlybitsNavigator): ViewModelProvider.Factory {

    private val contentGetter = ContentGetter(context.applicationContext)

    private val notificationContentRepository = NotificationContentRepository(PushGetter(context.applicationContext)
            , contentGetter, ModelConverter(contentGetter, flybitsViewProviderGetter))

    override fun <T : ViewModel?> create(modelClass: Class<T>): T {
        return if (modelClass.isAssignableFrom(NotificationsViewModel::class.java)){
            NotificationsViewModel(notificationContentRepository, flybitsViewProviderGetter, flybitsNavigator) as T
        } else {
            throw IllegalArgumentException("ViewModel Not Found")
        }
    }
}