package com.flybits.concierge.models

import android.os.Parcel
import android.os.Parcelable
import com.flybits.android.kernel.models.LocalizedValue
import com.flybits.android.kernel.models.PagedArray

/**
 * The {@link ActionCard} class is used to define all the necessary parameters associated to
 * ActionCard content template (Streamlined Content template 3)
 */
class ActionCard : BaseTemplate {

    var title: LocalizedValue? = null
    var header: LocalizedValue? = null
    var description: LocalizedValue? = null
    var image: LocalizedValue? = null
    var buttons: PagedArray<CardLink>? = null
    var details: Details? = null

    constructor(parcel: Parcel) : super(parcel) {
        title = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        header = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        description = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        image = parcel.readParcelable(LocalizedValue::class.java.classLoader)
        buttons = parcel.readParcelable(PagedArray::class.java.classLoader)
        details = parcel.readParcelable(Details::class.java.classLoader)
    }

    constructor() : super()

    override fun writeToParcel(dest: Parcel?, flags: Int) {
        super.writeToParcel(dest, flags)
        dest?.let {
            it.writeParcelable(title, flags)
            it.writeParcelable(header, flags)
            it.writeParcelable(description, flags)
            it.writeParcelable(image, flags)
            it.writeParcelable(buttons, flags)
            it.writeParcelable(details, flags)
        }
    }

    override fun describeContents(): Int = 0

    companion object {
        @JvmField
        val CREATOR: Parcelable.Creator<ActionCard> =
            object : Parcelable.Creator<ActionCard> {
                override fun createFromParcel(`in`: Parcel): ActionCard? {
                    return ActionCard(`in`)
                }

                override fun newArray(size: Int): Array<ActionCard?> {
                    return arrayOfNulls(size)
                }
            }
    }
}