package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.*
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.viewmodels.OptInViewModel
import com.flybits.concierge.viewmodels.OptInViewModelFactory
import kotlinx.android.synthetic.main.flybits_con_fragment_opt_out_confirmation.*

class OptOutConfirmationFragment : Fragment() {
    internal var viewModel: OptInViewModel? = null
    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_opt_out_confirmation, container, false)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        viewModel = ViewModelProviders.of(this, OptInViewModelFactory(context!!))
            .get(OptInViewModel::class.java)
        super.onCreate(savedInstanceState)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        opt_out_confirmation_btn.setOnClickListener {
            // on click OPT IN, we setOptOutConfirmationAdded(true)
            InternalPreferences.setOptOutConfirmationAdded(context, true)
            if(InternalPreferences.is2PhaseOptIn(context)) {
                viewModel?.optInOnOptOutConfirmation2Phase()
            } else {
                viewModel?.optInOnOptOutConfirmation()
            }
        }
    }

    companion object {
        const val OPTOUT_CONF_FRAG_STACK_TAG = "BACK_STACK_TAG"
        @JvmStatic
        fun newInstance(): OptOutConfirmationFragment {
            val fragment = OptOutConfirmationFragment()
            val args = Bundle()
            fragment.arguments = args
            return fragment
        }
    }

    override fun onDestroy() {
        super.onDestroy()
        viewModel = null
    }
}