package com.flybits.concierge.activities

import android.os.Bundle
import android.util.Log
import android.view.MenuItem
import com.flybits.concierge.ConciergeFragment
import com.flybits.concierge.DisplayConfiguration
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.enums.DisplayType
import com.flybits.concierge.fragments.OptOutConfirmationFragment.Companion.OPTOUT_CONF_FRAG_STACK_TAG

/**
 * Wrapper activity to hold the ConciergeFragment if the developer does not want to embed
 * the fragment in their views.
 */

class ConciergeActivity : ConciergeAbstractActivity() {

    lateinit var fragment:ConciergeFragment
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.flybits_con_activity_concierge)
        setTitle(R.string.flybits_con_concierge)

        val actionBar = supportActionBar
        if (actionBar != null) {
            actionBar.setHomeButtonEnabled(true)
            actionBar.setDisplayHomeAsUpEnabled(true)
        }

        val menuType = if (supportActionBar != null) {
            ConciergeFragment.MenuType.MENU_TYPE_APP_BAR
        } else {
            ConciergeFragment.MenuType.MENU_TYPE_TAB
        }
        fragment = ConciergeFragment.newInstance(
            intent.getParcelableExtra<DisplayConfiguration>(ARG_DISPLAY_CONFIGURATION)
        )
        fragment.setCallback { finish() }
        openFragment(fragment)
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        return if (item?.itemId == android.R.id.home) {
            // if OptOutConfirmation is not added, onBackPressed will finish the activity
            if (!InternalPreferences.isOptOutConfirmationAdded(this)){
                this.finish()
            }
            else{
                onBackPressed()
            }
            true
        }
        else {
            super.onOptionsItemSelected(item)
        }
    }

    override fun onBackPressed() {
        if (!InternalPreferences.isOptOutConfirmationAdded(this)) {
            this.finish()
        } else {
            InternalPreferences.setOptOutConfirmationAdded(this,false)
            if(InternalPreferences.is2PhaseOptIn(this)) {
                fragment.initializeState(DisplayType.SHOW_OPT_OUT_CONFIRMATION)
            } else{
                fragment.initializeState(false)
            }
        }
    }

    companion object {
        const val ARG_DISPLAY_CONFIGURATION = "flybits_con_display_configuration"
    }
}
