package com.flybits.concierge.viewmodels

import android.arch.lifecycle.ViewModel
import com.flybits.commons.library.api.results.callbacks.ObjectResultCallback
import com.flybits.concierge.models.CategorySettings
import com.flybits.concierge.repository.category.CategorySettingsRepository

class FeedHolderViewModel(private val categorySettingsRepository: CategorySettingsRepository) :
    ViewModel() {

    fun getCategories() = categorySettingsRepository.getCategorySettingsLocal()

    fun syncCategories(objectResultCallBack: ObjectResultCallback<CategorySettings>? = null) =
        categorySettingsRepository.getCategorySettingsRemote(objectResultCallBack)

}