package com.flybits.concierge.viewpopulators

import android.content.Intent
import android.net.Uri
import android.support.v4.view.ViewPager
import android.text.TextUtils
import android.view.View
import android.widget.TextView
import com.bumptech.glide.Glide
import com.bumptech.glide.load.DecodeFormat
import com.bumptech.glide.request.RequestOptions
import com.flybits.android.kernel.ContentAnalytics
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.adapters.ArticleAdapter
import com.flybits.concierge.models.Article
import com.flybits.concierge.models.Articles
import android.widget.ImageView as ImageView

/**
 *  Handles logic to bind Article data with Article views
 */
class ArticlesViewPopulator(private val contentAnalytics: ContentAnalytics) {
    val TAG = "ArtiViewPop"

    /**
     * Binds the article data with Article views
     *
     * @param article Article object containing information to be added to the views
     *
     */
    fun populate(article: Article, contentId: String, imgHeader : ImageView, txtTitle : TextView,
                 txtSource : TextView, txtDescription : TextView, thisView : View) {
        val options = RequestOptions().format(DecodeFormat.PREFER_RGB_565)

        Glide.with(imgHeader.context)
            .load(article.imageURL)
            .apply(options)
            .into(imgHeader)

        txtTitle.text = article.title.value
        txtSource.visibility = if (!TextUtils.isEmpty(article.sourceName)) View.VISIBLE else View.INVISIBLE
        txtSource.text = article.sourceName
        txtDescription.text = article.description.value

        thisView.setOnClickListener { v ->
            contentAnalytics.trackEngaged(contentId)
            contentAnalytics.trackFulfilled(contentId)
            val url = article.url
            val intent = Intent(Intent.ACTION_VIEW)
            intent.data = Uri.parse(url)
            if(intent.resolveActivity(v.context.packageManager) != null) {
                v.context.startActivity(intent)
            } else {
                Logger.appendTag(TAG).e("Invalid url for Article")
            }
        }
    }

    /**
     * Bind the Articles data into an adapter if we have multiple articles otherwise into
     * an Article's views
     *
     * @param data List of articles
     */
    fun populate(data: Articles, viewPager: ViewPager, singleView: View, imgHeader: ImageView
                 , txtTitle: TextView, txtSource: TextView, txtDescription: TextView, thisView: View){
        viewPager.visibility = View.GONE
        singleView.visibility = View.GONE
        val articleList = data.articles.list

        if (articleList.size > 1) {
            viewPager.visibility = View.VISIBLE
            val adapter = ArticleAdapter(this)
            viewPager.adapter = adapter
            adapter.setData(data.articles.list, data.content.id)
        } else if (articleList.size == 1) {
            singleView.visibility = View.VISIBLE
            populate(articleList[0], data.content.id, imgHeader, txtTitle, txtSource, txtDescription, thisView)
        }
    }
}