package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.content.pm.ActivityInfo
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.flybits.concierge.R
import com.flybits.concierge.viewmodels.TransitionLoaderViewModel
import com.flybits.concierge.viewmodels.TransitionLoaderViewModelFactory


/**
 * The Fragment is responsible for showing the Loading Screen till the [ConciergeConnectCallBack#connect] is called by the user.
 */

class TransitionLoaderFragment : Fragment() {

    private var viewModel: TransitionLoaderViewModel? = null
    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_transition_loader, container, false)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        viewModel = ViewModelProviders.of(this, TransitionLoaderViewModelFactory(context!!))
            .get(TransitionLoaderViewModel::class.java)
    }

    override fun onDestroy() {
        super.onDestroy()
        viewModel = null
        activity?.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_FULL_SENSOR
    }

    companion object {
        fun newInstance(): TransitionLoaderFragment {
            val fragment = TransitionLoaderFragment()
            val arguments = Bundle()
            fragment.arguments = arguments
            return fragment
        }
    }
}
