package com.flybits.concierge.activities

import android.content.Intent
import android.support.v4.app.Fragment
import com.flybits.concierge.fragments.VideoFragment
import com.flybits.concierge.models.Video

class VideoActivity: SingleFragmentActivity() {

    companion object {
        const val EXTRA_VIDEO = "flybits_con_extra_video"
    }

    override fun onCreateSingleContentActivity(intent: Intent): Fragment {
        val video = intent.getParcelableExtra<Video>(EXTRA_VIDEO)
        title = video.title.value
        return VideoFragment.newInstance(video)
    }
}