package com.flybits.concierge.viewholders;

import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import com.flybits.concierge.FlybitsNavigator;
import com.flybits.concierge.R;
import com.flybits.concierge.models.Video;
import com.flybits.concierge.viewpopulators.VideoViewPopulator;

public class VideoViewHolder extends FlybitsViewHolder<Video>
{
    private final TextView titleTextView;
    private final TextView durationTextView;
    private final ImageView placeholderImageView;
    private View thisView;
    private VideoViewPopulator videoViewPopulator;

    public VideoViewHolder(VideoViewPopulator videoViewPopulator, View view)
    {
        super(view);
        this.thisView = view;
        this.videoViewPopulator = videoViewPopulator;
        titleTextView = view.findViewById(R.id.flybits_con_item_template_video_txtTitle);
        durationTextView = view.findViewById(R.id.flybits_con_item_template_video_txtDuration);
        placeholderImageView = view.findViewById(R.id.flybits_con_item_template_video_placeHolder);
    }

    @Override
    public void bindData(final Video data, FlybitsNavigator flybitsNavigator)
    {
        videoViewPopulator.populateVideoViews(data, data.getContent().getId(), flybitsNavigator
                , titleTextView, durationTextView, placeholderImageView, thisView);
    }
}
