package com.flybits.concierge.viewactionhandlers

import android.os.Bundle
import android.os.Parcel
import android.os.Parcelable
import android.support.design.widget.Snackbar
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.R
import com.flybits.concierge.ResourceProvider
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.activities.SimpleCardDetailActivity
import com.flybits.concierge.models.SimpleCard

open class SimpleCardUserActionHandler(private val resourceProvider: ResourceProvider? = null) :
    UserActionHandler<SimpleCard> {

    constructor(parcel: Parcel) : this()

    override fun writeToParcel(parcel: Parcel, flags: Int) {
    }

    override fun describeContents(): Int {
        return 0
    }

    override fun onUserAction(action: Int, data: SimpleCard, flybitsNavigator: FlybitsNavigator) {
        when (action) {
            LINK_CLICKED -> {
                when (data.link?.actionType) {
                    ActionType.LINK.name -> {
                        data.link?.actionValue?.value?.let {
                            if (!flybitsNavigator.openUrlInApp(it)) {
                                val message =
                                    resourceProvider?.getString(R.string.flybits_streamline_invalid_url)
                                flybitsNavigator.openSnackbar(
                                    message ?: "An error occurred while loading url",
                                    Snackbar.LENGTH_SHORT
                                )
                            }
                        }
                    }
                    ActionType.OPEN_DETAIL.name -> {
                        val bundle = Bundle()
                        bundle.putParcelable(
                            SimpleCardDetailActivity.EXTRA_SIMPLECARD_DETAILS,
                            data
                        )
                        bundle.putParcelable(
                            SimpleCardDetailActivity.EXTRA_USER_ACTION_HANDLER,
                            this
                        )
                        flybitsNavigator.openActivity(SimpleCardDetailActivity::class.java, bundle)
                    }
                    ActionType.CONTENT.name -> {
                        // To be implemented
                    }
                    ActionType.APP.name -> {
                        // To be implemented
                    }
                }
            }

            else -> throw IllegalArgumentException("Invalid action, action = $action")
        }
    }

    enum class ActionType {
        LINK,
        APP,
        CONTENT,
        OPEN_DETAIL;
    }

    companion object {
        const val LINK_CLICKED = 0

        @JvmField
        val CREATOR = object : Parcelable.Creator<SimpleCardUserActionHandler> {
            override fun createFromParcel(parcel: Parcel): SimpleCardUserActionHandler {
                return SimpleCardUserActionHandler(parcel)
            }

            override fun newArray(size: Int): Array<SimpleCardUserActionHandler?> {
                return arrayOfNulls(size)
            }
        }
    }

}