package com.flybits.concierge.viewactionhandlers

import android.os.Bundle
import android.os.Parcel
import android.os.Parcelable
import android.support.design.widget.Snackbar
import com.flybits.concierge.FlybitsNavigator
import com.flybits.concierge.R
import com.flybits.concierge.ResourceProvider
import com.flybits.concierge.UserActionHandler
import com.flybits.concierge.activities.ActionCardDetailActivity
import com.flybits.concierge.models.ActionCard

class ActionCardUserActionHandler(private val resourceProvider: ResourceProvider? = null) :
    UserActionHandler<ActionCard> {

    constructor(parcel: Parcel) : this()

    override fun writeToParcel(parcel: Parcel, flags: Int) {
    }

    override fun describeContents(): Int {
        return 0
    }

    override fun onUserAction(action: Int, data: ActionCard, flybitsNavigator: FlybitsNavigator) {
        when (action) {
            PRIMARY_CLICKED -> {
                when (data.buttons?.list?.get(0)?.actionType) {
                    ActionType.LINK.name -> {
                        val linkValue = data.buttons?.list?.get(0)?.actionValue?.value
                        linkClicked(linkValue, flybitsNavigator)
                    }
                    ActionType.OPEN_DETAIL.name -> {
                        openDetailsClicked(data, flybitsNavigator)
                    }
                    ActionType.CONTENT.name -> {
                        // To be implemented
                    }
                    ActionType.APP.name -> {
                        // To be implemented
                    }
                }
            }
            SECONDARY_CLICKED -> {
                when (data.buttons?.list?.get(1)?.actionType) {
                    ActionType.LINK.name -> {
                        val linkValue = data.buttons?.list?.get(1)?.actionValue?.value
                        linkClicked(linkValue, flybitsNavigator)
                    }
                    ActionType.OPEN_DETAIL.name -> {
                        openDetailsClicked(data, flybitsNavigator)
                    }
                    ActionType.CONTENT.name -> {
                        // To be implemented
                    }
                    ActionType.APP.name -> {
                        // To be implemented
                    }
                }
            }

            else -> throw IllegalArgumentException("Invalid action, action = $action")
        }
    }

    enum class ActionType {
        LINK,
        APP,
        CONTENT,
        OPEN_DETAIL;
    }

    private fun linkClicked(linkValue: String?, flybitsNavigator: FlybitsNavigator) {
        linkValue?.let {
            if (!flybitsNavigator.openUrlInApp(it)) {
                val message =
                    resourceProvider?.getString(R.string.flybits_streamline_invalid_url)
                flybitsNavigator.openSnackbar(
                    message ?: "An error occurred while loading url",
                    Snackbar.LENGTH_SHORT
                )
            }
        }
    }

    private fun openDetailsClicked(actionCard: ActionCard, flybitsNavigator: FlybitsNavigator) {
        val bundle = Bundle()
        bundle.putParcelable(
            ActionCardDetailActivity.EXTRA_ACTIONCARD_DETAILS,
            actionCard
        )
        bundle.putParcelable(
            ActionCardDetailActivity.EXTRA_USER_ACTION_HANDLER,
            this
        )
        flybitsNavigator.openActivity(ActionCardDetailActivity::class.java, bundle)
    }

    companion object {
        const val PRIMARY_CLICKED = 0
        const val SECONDARY_CLICKED = 1

        @JvmField
        val CREATOR = object : Parcelable.Creator<ActionCardUserActionHandler> {
            override fun createFromParcel(parcel: Parcel): ActionCardUserActionHandler {
                return ActionCardUserActionHandler(parcel)
            }

            override fun newArray(size: Int): Array<ActionCardUserActionHandler?> {
                return arrayOfNulls(size)
            }
        }
    }

}