package com.flybits.concierge.fragments

import android.arch.lifecycle.Observer
import android.arch.lifecycle.ViewModelProviders
import android.content.Intent
import android.content.pm.ActivityInfo
import android.graphics.Color
import android.graphics.Typeface
import android.os.Bundle
import android.support.v4.app.Fragment
import android.text.Spannable
import android.text.SpannableStringBuilder
import android.text.TextPaint
import android.text.method.LinkMovementMethod
import android.text.style.ClickableSpan
import android.text.style.StyleSpan
import android.view.*
import com.afollestad.materialdialogs.MaterialDialog
import com.flybits.commons.library.logging.Logger
import com.flybits.concierge.InternalPreferences
import com.flybits.concierge.R
import com.flybits.concierge.activities.DocumentActivity
import com.flybits.concierge.viewmodels.OptInViewModel
import com.flybits.concierge.viewmodels.OptInViewModelFactory
import kotlinx.android.synthetic.main.flybits_con_fragment_opt_in.*

const val TAG_OPTIN = "OptInFragment"

class OptInFragment : Fragment() {

    internal var viewModel: OptInViewModel? = null


    companion object {
        fun newInstance(): OptInFragment {
            return OptInFragment()
        }
    }

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.flybits_con_fragment_opt_in, container, false)
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)

        viewModel = ViewModelProviders.of(this, OptInViewModelFactory(context!!))
            .get(OptInViewModel::class.java)
        activity?.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        opt_in_text_body.text = viewModel?.optInText
        opt_in_text_title.text = viewModel?.optInTitle

        setHasOptionsMenu(true)
        //Set the footer text
        viewModel?.footerSpan?.observe(this, Observer<OptInViewModel.Span> { span ->
            span?.let {
                val str = SpannableStringBuilder(it.text)
                str.setSpan(StyleSpan(Typeface.BOLD), it.tncStartIndex, it.privacyPolicyEndIndex, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                val tncClickableSpan = object : ClickableSpan() {
                    override fun onClick(textView: View) {
                        val activityIntent = Intent(context, DocumentActivity::class.java)
                        activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_TOS)
                        startActivity(activityIntent)
                    }

                    override fun updateDrawState(ds : TextPaint) {
                        super.updateDrawState(ds)
                        ds.isUnderlineText = false
                        ds.color = Color.parseColor(getString(R.string.flybits_blue))
                    }
                }
                str.setSpan(tncClickableSpan, it.tncStartIndex, it.tncEndIndex, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)

                val ppClickableSpan = object : ClickableSpan() {
                    override fun onClick(textView: View) {
                        val activityIntent = Intent(context, DocumentActivity::class.java)
                        activityIntent.putExtra(DocumentActivity.EXTRA_DOCUMENT_TYPE, DocumentActivity.DOCUMENT_TYPE_PRIVACY_POLICY)
                        startActivity(activityIntent)
                    }

                    override fun updateDrawState(ds : TextPaint) {
                        super.updateDrawState(ds)
                        ds.isUnderlineText = false
                        ds.color = Color.parseColor(getString(R.string.flybits_blue))
                    }
                }
                str.setSpan(ppClickableSpan, it.privacyPolicyStartIndex, it.privacyPolicyEndIndex, Spannable.SPAN_EXCLUSIVE_EXCLUSIVE)
                text_footer.text = str
                text_footer.movementMethod = LinkMovementMethod.getInstance()
                text_footer.highlightColor = Color.TRANSPARENT
            }
        })
        checkbox_optin.setOnClickListener {
            viewModel?.checkboxSelected()
        }

        viewModel?.checkboxState?.observe(this, Observer<Boolean> {
            checkbox_optin.isSelected = it ?: false
            btn_continue.isEnabled = it ?: false
        })

        btn_continue.setOnClickListener {
            val fm = activity?.supportFragmentManager
            if(fm != null){
                // on click continue, setOptOutConfirmationAdded(false)
                InternalPreferences.setOptOutConfirmationAdded(context, false)
            }
            progress_bar?.visibility = View.VISIBLE
            if (!InternalPreferences.is2PhaseOptIn(context)) {
                viewModel?.optIn()?.observe(this, Observer<OptInViewModel.OptInResult> {
                    if (it?.success == true) {
                        Logger.appendTag(TAG_OPTIN).d("User has opted in successfully.")
                        //Do nothing, concierge fragment will handle transition
                    } else {
                        context?.let { contextNonNull ->
                            MaterialDialog.Builder(contextNonNull)
                                .title(R.string.flybits_con_error)
                                .content(getString(R.string.flybits_con_opt_in_error_message))
                                .positiveText(android.R.string.ok)
                                .show()
                        }
                    }
                    progress_bar?.visibility = View.GONE
                })
            } else {
                progress_bar?.visibility = View.GONE
                viewModel?.optInInitiated()
            }
            // remove "NO THANKS" before next fragment loads
            setMenuVisibility(false)
        }
    }

    override fun onOptionsItemSelected(item: MenuItem?): Boolean {
        val id = item?.itemId
        if (id == R.id.declineOptin) {
            viewModel?.declinedOptIn()
            activity?.onBackPressed()
            return true
        }
        return false
    }

    // show "NO THANKS" on the fragment from OptOutConfirmationFragment
    override fun onCreateOptionsMenu(menu: Menu, inflater: MenuInflater) {
        menu.findItem(R.id.declineOptin).isVisible = true
    }

    override fun onDestroy() {
        super.onDestroy()
        viewModel = null
    }
}