package com.flybits.concierge.repository.category

import android.arch.persistence.room.TypeConverter
import org.json.JSONArray
import org.json.JSONException

class SetConverter {
    companion object {
        @TypeConverter
        @JvmStatic
        fun fromString(json: String?): Set<String> {

            if (json == null) return emptySet()

            return try{
                val set = mutableSetOf<String>()
                val jsonArray = JSONArray(json)
                for (i in 0 until jsonArray.length()){
                    set.add(jsonArray.getString(i))
                }
                set
            } catch (e: JSONException) {
                emptySet()
            }
        }

        @TypeConverter
        @JvmStatic
        fun toString(set: Set<String>?): String {

            return try{
                val jsonArray = JSONArray()
                set?.forEach { jsonArray.put(it) }
                jsonArray.toString()
            } catch (e: Exception) {
                "[]"
            }
        }
    }
}