package com.flybits.concierge.fragments

import android.arch.lifecycle.ViewModelProviders
import android.content.pm.ActivityInfo
import android.os.Bundle
import android.support.v4.app.Fragment
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import com.flybits.concierge.R
import com.flybits.concierge.viewmodels.OptInViewModel
import com.flybits.concierge.viewmodels.OptInViewModelFactory
import kotlinx.android.synthetic.main.fragment_opt_in_error_state.*

/**
 * This is visible when 2 phase Opt in is unsuccessful
 */

class OptInErrorStateFragment : Fragment() {
    private var errorString: String? = null

    internal var viewModel: OptInViewModel? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        arguments?.let {
            errorString = it.getString(ARGS_ERRORSTRING)
        }
        viewModel = ViewModelProviders.of(this, OptInViewModelFactory(context!!))
            .get(OptInViewModel::class.java)
        activity?.requestedOrientation = ActivityInfo.SCREEN_ORIENTATION_PORTRAIT
    }

    override fun onCreateView(
        inflater: LayoutInflater, container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        // Inflate the layout for this fragment
        return inflater.inflate(R.layout.fragment_opt_in_error_state, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        optIn_errorString.text = errorString

        optin_error_button.setOnClickListener {
            viewModel?.optInErrorAction()
        }
    }


    companion object {

        private const val ARGS_ERRORSTRING = "ERROR_STRING"

        fun newInstance(errorString: String): OptInErrorStateFragment {
            val fragment = OptInErrorStateFragment()
            val arguments = Bundle()
            fragment.arguments = arguments
            arguments.putString(ARGS_ERRORSTRING, errorString)
            return fragment

        }
    }
}
